/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector.handler.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.SettableFuture;
import com.gigaspaces.lrmi.nio.selector.handler.client.Conversation;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ClientConversationRunner
implements Runnable {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final long SELECT_TIMEOUT = Long.getLong("com.gs.lrmi.nio.selector.select-timeout", 10000L);
    private final Selector selector;
    private final Queue<Conversation> registrationConversations = new ConcurrentLinkedQueue<Conversation>();

    public ClientConversationRunner() throws IOException {
        this.selector = SelectorProvider.provider().openSelector();
    }

    public SettableFuture<Conversation> addConversation(Conversation conversation) {
        this.registrationConversations.add(conversation);
        this.selector.wakeup();
        return conversation.future();
    }

    @Override
    public void run() {
        while (this.selector.isOpen()) {
            this.doSelect();
        }
    }

    private void doSelect() {
        block6: {
            SelectionKey key = null;
            try {
                this.addNewRegistrations();
                this.selector.select(SELECT_TIMEOUT);
                Set<SelectionKey> keys = this.selector.selectedKeys();
                if (keys == null || keys.isEmpty()) {
                    return;
                }
                Iterator<SelectionKey> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    iterator.remove();
                    Conversation conversation = (Conversation)key.attachment();
                    conversation.handleKey(key);
                }
            }
            catch (ClosedSelectorException ex) {
                logger.log(Level.FINER, "Selector was closed.", ex);
                if (key != null) {
                    key.cancel();
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "exception in main selection loop", t);
                if (key == null) break block6;
                key.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewRegistrations() {
        if (this.registrationConversations.isEmpty()) {
            return;
        }
        Iterator iterator = this.registrationConversations.iterator();
        while (iterator.hasNext()) {
            Conversation conversation = (Conversation)iterator.next();
            try {
                conversation.channel().register(this.selector, 8, conversation);
            }
            catch (Throwable t) {
                SelectionKey key = conversation.channel().keyFor(this.selector);
                if (key != null) {
                    key.cancel();
                }
                conversation.close(t);
            }
            finally {
                iterator.remove();
            }
        }
    }
}

