/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector.handler.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.nio.selector.handler.AbstractSelectorThread;
import com.gigaspaces.lrmi.nio.selector.handler.client.Context;
import com.gigaspaces.lrmi.nio.selector.handler.client.InterestRequest;
import com.gigaspaces.lrmi.nio.selector.handler.client.RegistrationRequest;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

@InternalApi
public class ClientHandler
extends AbstractSelectorThread {
    private final Queue<RegistrationRequest> _registrations = new ConcurrentLinkedQueue<RegistrationRequest>();
    private final AtomicInteger _registrationsCounter = new AtomicInteger();
    private final Queue<InterestRequest> _interests = new ConcurrentLinkedQueue<InterestRequest>();
    private final AtomicInteger _interestsCounter = new AtomicInteger();

    public ClientHandler() throws IOException {
        super(null);
    }

    @Override
    protected void enableSelectionKeys() {
        this.handleRegistrations();
        this.interestSelectionKeys();
    }

    private void handleRegistrations() {
        int size = this._registrationsCounter.get();
        boolean hasUnregisterRequests = false;
        for (int i = 0; i < size; ++i) {
            RegistrationRequest request = this._registrations.poll();
            this._registrationsCounter.decrementAndGet();
            if (request.getAction() == RegistrationRequest.Action.REGISTER) {
                this.register(request);
                continue;
            }
            if (request.getAction() != RegistrationRequest.Action.UNREGISTER) continue;
            hasUnregisterRequests = true;
            this.unregister(request);
        }
        if (hasUnregisterRequests) {
            this.getSelector().wakeup();
        }
    }

    private void unregister(RegistrationRequest request) {
        Context context = request.getContext();
        try {
            SelectionKey selectionKey = context.getSelectionKey();
            selectionKey.attach(null);
            SelectableChannel channel = selectionKey.channel();
            selectionKey.cancel();
            this.getSelector().selectNow();
            if (channel.isOpen()) {
                channel.configureBlocking(true);
            }
            context.close();
        }
        catch (Throwable t) {
            _logger.log(Level.INFO, t.toString(), t);
            context.closeAndDisconnect();
        }
    }

    private void register(RegistrationRequest request) {
        SocketChannel channel = request.getChannel();
        Context ctx = request.getContext();
        try {
            channel.configureBlocking(false);
            SelectionKey selectionKey = channel.register(this.getSelector(), 4);
            ctx.setSelectionKey(selectionKey);
            selectionKey.attach(ctx);
        }
        catch (Throwable t) {
            ctx.close(t);
            _logger.log(Level.WARNING, t.toString(), t);
        }
    }

    private void interestSelectionKeys() {
        int size = this._interestsCounter.get();
        for (int i = 0; i < size; ++i) {
            InterestRequest request = this._interests.remove();
            this._interestsCounter.decrementAndGet();
            int ops = 0;
            switch (request.getAction()) {
                case WRITE: {
                    ops = 4;
                    break;
                }
                case READ: {
                    request.getContext().handleSetReadInterest();
                    ops = 1;
                }
            }
            SelectionKey selectionKey = request.getContext().getSelectionKey();
            if (selectionKey == null) {
                return;
            }
            try {
                selectionKey.interestOps(ops);
                continue;
            }
            catch (CancelledKeyException e) {
                this.cancelKey(selectionKey);
            }
        }
    }

    @Override
    protected void handleConnection(SelectionKey key) throws IOException, InterruptedException {
        Context ctx = (Context)key.attachment();
        if (key.isReadable()) {
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
            ctx.handleRead();
        } else if (key.isWritable()) {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            ctx.handleWrite();
        }
    }

    public void addChannel(SocketChannel channelSocket, Context ctx) {
        this._registrations.offer(new RegistrationRequest(channelSocket, ctx, RegistrationRequest.Action.REGISTER));
        this._registrationsCounter.incrementAndGet();
        this.getSelector().wakeup();
    }

    public void removeChannel(SocketChannel channelSocket, Context ctx) {
        this._registrations.offer(new RegistrationRequest(channelSocket, ctx, RegistrationRequest.Action.UNREGISTER));
        this._registrationsCounter.incrementAndGet();
        if (this.ownerThread != Thread.currentThread()) {
            this.getSelector().wakeup();
        }
    }

    public void setReadInterest(Context ctx) {
        this._interests.add(new InterestRequest(ctx, InterestRequest.Action.READ));
        this._interestsCounter.incrementAndGet();
    }

    public void setWriteInterest(Context ctx) {
        this._interests.add(new InterestRequest(ctx, InterestRequest.Action.WRITE));
        this._interestsCounter.incrementAndGet();
        if (this.ownerThread != Thread.currentThread()) {
            this.getSelector().wakeup();
        }
    }

    @Override
    protected void cancelKey(SelectionKey key) {
        Context ctx = (Context)key.attachment();
        if (ctx != null) {
            ctx.setSelectionKey(null);
            ctx.close(new ClosedChannelException());
        }
    }

    public void shutdown() {
        this.requestShutdown();
    }
}

