/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector.handler.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.SettableFuture;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.nio.selector.handler.client.AbstractChat;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

@InternalApi
public class Conversation {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.lrmi");
    private final SocketChannel channel;
    private final SettableFuture<Conversation> future = new SettableFuture();
    private final List<AbstractChat> chats;
    private AbstractChat currentChat;

    public Conversation(InetSocketAddress address) throws IOException {
        this.channel = SocketChannel.open();
        this.chats = new ArrayList<AbstractChat>();
        try {
            this.channel.configureBlocking(false);
            LRMIUtilities.initNewSocketProperties(this.channel);
            this.channel.connect(address);
        }
        catch (Exception e) {
            this.channel.close();
            throw new IOException(e);
        }
    }

    public SocketChannel channel() {
        return this.channel;
    }

    public SettableFuture<Conversation> future() {
        return this.future;
    }

    public void close(Throwable cause) {
        if (!this.future.isDone()) {
            this.future.setResult(cause);
        }
        try {
            this.channel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void handleKey(SelectionKey key) {
        if (!key.channel().isOpen()) {
            key.cancel();
        }
        if (!key.isValid()) {
            this.canceledKey();
            return;
        }
        if (key.isConnectable()) {
            int ops = key.interestOps();
            key.interestOps(ops &= 0xFFFFFFF7);
            this.finishConnection(key);
        }
        this.processChats(key);
    }

    private void processChats(SelectionKey key) {
        while (true) {
            boolean chatDone;
            if (this.chats.isEmpty() && this.currentChat == null) {
                key.cancel();
                this.future.setResult(this);
                return;
            }
            if (this.currentChat == null) {
                this.currentChat = this.chats.remove(0);
                chatDone = this.currentChat.init(this, key);
            } else {
                chatDone = this.currentChat.process(key);
            }
            if (!chatDone) break;
            this.currentChat = null;
        }
    }

    private void canceledKey() {
        if (!this.future.isDone()) {
            this.future.setResult(new ClosedChannelException());
        }
    }

    private void finishConnection(SelectionKey key) {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        try {
            socketChannel.finishConnect();
        }
        catch (Throwable t) {
            key.cancel();
            this.close(t);
        }
    }

    public void addChat(AbstractChat chat) {
        this.chats.add(chat);
    }
}

