/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector.handler.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.GSByteArrayOutputStream;
import com.gigaspaces.internal.io.MarshalOutputStream;
import com.gigaspaces.lrmi.nio.RequestPacket;
import com.gigaspaces.lrmi.nio.selector.handler.client.AbstractChat;
import com.gigaspaces.lrmi.nio.selector.handler.client.Conversation;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;

@InternalApi
public class LRMIChat
extends AbstractChat<ByteBuffer> {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.lrmi");
    private ByteBuffer msg;
    private final ByteBuffer headerBuffer;
    private ByteBuffer readBuf;
    private Mode mode;

    public LRMIChat(RequestPacket packet) throws IOException {
        GSByteArrayOutputStream bos = new GSByteArrayOutputStream();
        bos.setSize(4);
        MarshalOutputStream mos = new MarshalOutputStream(bos, false);
        ByteBuffer buffer = this.wrap(bos);
        packet.writeExternal(mos);
        this.msg = this.prepareBuffer(mos, bos, buffer);
        this.mode = Mode.WRITE;
        this.headerBuffer = ByteBuffer.allocate(4);
        this.headerBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public boolean init(Conversation conversation, SelectionKey key) {
        this.conversation = conversation;
        return this.process(key);
    }

    @Override
    public boolean process(SelectionKey key) {
        if (!key.isValid()) {
            return false;
        }
        if (this.mode == Mode.WRITE) {
            byte writeResult = this.write(key, this.msg);
            if (-1 == writeResult) {
                return true;
            }
            if (1 == writeResult) {
                this.mode = Mode.HEADER;
                this.addInterest(key, 1);
            }
            return false;
        }
        return this.read(key);
    }

    @Override
    public ByteBuffer result() {
        return this.readBuf;
    }

    private boolean read(SelectionKey key) {
        if (!key.isReadable()) {
            return false;
        }
        SocketChannel channel = (SocketChannel)key.channel();
        if (this.mode == Mode.HEADER) {
            try {
                if (0 > channel.read(this.headerBuffer)) {
                    key.cancel();
                    this.conversation.close(new EOFException("end of stream has been reached unexpectedly during read of header"));
                    return true;
                }
            }
            catch (Throwable t) {
                key.cancel();
                this.conversation.close(t);
                return true;
            }
            if (this.headerBuffer.remaining() == 0) {
                this.headerBuffer.flip();
                int size = this.headerBuffer.getInt();
                this.readBuf = ByteBuffer.allocate(size);
                this.mode = Mode.READ;
            } else {
                return false;
            }
        }
        if (this.mode == Mode.READ) {
            try {
                if (0 > channel.read(this.readBuf)) {
                    key.cancel();
                    this.conversation.close(new EOFException("end of stream has been reached unexpectedly during input"));
                    return true;
                }
            }
            catch (Throwable t) {
                key.cancel();
                this.conversation.close(t);
                return true;
            }
            if (this.readBuf.remaining() == 0) {
                this.readBuf.flip();
                this.removeInterest(key, 1);
                return true;
            }
            return false;
        }
        return false;
    }

    private ByteBuffer wrap(GSByteArrayOutputStream bos) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bos.getBuffer());
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer;
    }

    private ByteBuffer prepareBuffer(MarshalOutputStream mos, GSByteArrayOutputStream bos, ByteBuffer byteBuffer) throws IOException {
        mos.flush();
        int length = bos.size();
        if (byteBuffer.array() != bos.getBuffer()) {
            byteBuffer = this.wrap(bos);
        } else {
            byteBuffer.clear();
        }
        byteBuffer.putInt(length - 4);
        byteBuffer.position(length);
        byteBuffer.flip();
        return byteBuffer;
    }

    private static enum Mode {
        WRITE,
        READ,
        HEADER;

    }
}

