/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.watchdog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.ConnectionResource;
import com.gigaspaces.lrmi.nio.watchdog.TimeoutObserver;
import com.gigaspaces.lrmi.nio.watchdog.Watchdog;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class IdleConnectionTimeoutObserver
implements TimeoutObserver {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi.watchdog");
    private final int _retries;

    public IdleConnectionTimeoutObserver(int retries) {
        this._retries = retries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeoutOccured(Collection<Watchdog.WatchedObject> bucket) throws Exception {
        for (Watchdog.WatchedObject watchedObject : bucket) {
            Watchdog.ClientWatchedObject clientWatched = (Watchdog.ClientWatchedObject)watchedObject;
            ConnectionResource cPeer = clientWatched.getClient();
            if (!cPeer.acquire()) {
                clientWatched._retries = 0;
                clientWatched.startWatch();
                return;
            }
            try {
                if (clientWatched._retries < this._retries && cPeer.sendKeepAlive()) {
                    ++clientWatched._retries;
                    clientWatched.startWatch();
                    continue;
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Closing idle connection to " + cPeer.getConnectionURL());
                }
                clientWatched.stopWatch();
                cPeer.disconnect();
            }
            finally {
                cPeer.setAcquired(false);
            }
        }
    }
}

