/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.watchdog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.GSByteArrayInputStream;
import com.gigaspaces.internal.io.MarshalInputStream;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ConnectionResource;
import com.gigaspaces.lrmi.nio.CPeer;
import com.gigaspaces.lrmi.nio.ChannelEntry;
import com.gigaspaces.lrmi.nio.ProtocolValidation;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.watchdog.RequestTimeoutObserver;
import com.gigaspaces.lrmi.nio.watchdog.Watchdog;
import com.gigaspaces.time.SystemTime;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@InternalApi
public class RequestResponseTimeoutObserver
extends RequestTimeoutObserver {
    static final boolean DISABLE_RESPONSE_WATCH = Boolean.parseBoolean(System.getProperty("com.gs.transport_protocol.lrmi.response_watch.disable", "false"));
    private final boolean _protocolValidationEnabled;
    private long _lastDisconnectionTimestamp = 0L;

    public RequestResponseTimeoutObserver(long requestTimeout, boolean protocolValidationEnabled) {
        super(requestTimeout);
        this._protocolValidationEnabled = protocolValidationEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleOpenSocket(SocketChannel socketChannel, int watchedSocketLocalPort, long absoluteTimeout, ConnectionResource connectionResource) throws IOException {
        if (DISABLE_RESPONSE_WATCH) {
            super.handleOpenSocket(socketChannel, watchedSocketLocalPort, absoluteTimeout, connectionResource);
            return;
        }
        PlatformLogicalVersion serviceVersion = ((CPeer)connectionResource).getServiceVersion();
        if (serviceVersion.lessThan(PlatformLogicalVersion.v9_5_0)) {
            return;
        }
        Socket socket = socketChannel.socket();
        if (socket == null) {
            throw new IOException("Socket closed for: " + socketChannel + " [no socket]");
        }
        SocketAddress remoteSocketAddress = socket.getRemoteSocketAddress();
        if (remoteSocketAddress == null) {
            throw new IOException("Socket closed for: " + socketChannel + "[no remote socket address]");
        }
        boolean previousIsBlocking = socketChannel.isBlocking();
        socketChannel.configureBlocking(false);
        try {
            if (this._protocolValidationEnabled) {
                this.writeProtocolValidationHeader(socketChannel, absoluteTimeout);
            }
            this.writeWatchdogMonitorSystemRequest(socketChannel, watchedSocketLocalPort, absoluteTimeout, remoteSocketAddress, serviceVersion);
            this.readWatchdogMonitorSystemResponse(socketChannel, absoluteTimeout, remoteSocketAddress, serviceVersion);
        }
        finally {
            socketChannel.configureBlocking(previousIsBlocking);
        }
    }

    @Override
    protected String getValidConnectionMessage(SocketAddress serverAddress) {
        if (DISABLE_RESPONSE_WATCH) {
            return super.getValidConnectionMessage(serverAddress);
        }
        return "Established new connection with the ServerEndPoint [" + serverAddress + "] and verified current invocation is in progress. Assuming connection is valid.";
    }

    @Override
    protected String getInvalidConnectionMessage(SocketAddress serverAddress, SocketChannel watchedSocketChannel, Watchdog.WatchedObject watched) {
        if (DISABLE_RESPONSE_WATCH) {
            return super.getInvalidConnectionMessage(serverAddress, watchedSocketChannel, watched);
        }
        String suffix = RequestResponseTimeoutObserver.getWatchedObjectInvocationMessage(watched);
        return "The ServerEndPoint [" + serverAddress + "] is not reachable or is reachable but with no matching invocation in progress at the server peer, closing invalid connection with local address [" + this.getLocalAddressString(watchedSocketChannel) + "]" + suffix;
    }

    @Override
    protected String getFailureToCloseInvalidConnectionMessage(SocketAddress serverAddress, SocketChannel watchedSocketChannel) {
        if (DISABLE_RESPONSE_WATCH) {
            return super.getFailureToCloseInvalidConnectionMessage(serverAddress, watchedSocketChannel);
        }
        return "A connection to the ServerEndPoint [" + watchedSocketChannel.socket().getRemoteSocketAddress() + "] that has no invocation in progress at the server peer, could not be closed. ";
    }

    @Override
    protected Level getCloseConnectionLoggingLevel() {
        if (DISABLE_RESPONSE_WATCH) {
            return super.getCloseConnectionLoggingLevel();
        }
        Level result = Level.FINE;
        long timeMillis = SystemTime.timeMillis();
        if (this._lastDisconnectionTimestamp > 0L && timeMillis < this._lastDisconnectionTimestamp + TimeUnit.MINUTES.toMillis(1L)) {
            result = Level.WARNING;
        }
        this._lastDisconnectionTimestamp = timeMillis;
        return result;
    }

    private void writeWatchdogMonitorSystemRequest(SocketChannel socketChannel, int watchedSocketLocalPort, long absoluteTimeout, SocketAddress remoteSocketAddress, PlatformLogicalVersion serviceVersion) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Writing watch monitor request to the ServerEndpoint at [" + remoteSocketAddress + "]");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        int requestCode = serviceVersion.lessThan(PlatformLogicalVersion.v9_6_0) ? -2 : -3;
        byteBuffer.putInt(requestCode);
        byteBuffer.putInt(watchedSocketLocalPort);
        byteBuffer.flip();
        while (byteBuffer.hasRemaining() && SystemTime.timeMillis() < absoluteTimeout) {
            int writtenBytes = socketChannel.write(byteBuffer);
            if (writtenBytes != 0) continue;
            Thread.yield();
        }
        if (byteBuffer.hasRemaining()) {
            throw new SocketTimeoutException("Timed out during monitoring connection [write system request]");
        }
    }

    private void readWatchdogMonitorSystemResponse(SocketChannel socketChannel, long absoluteTimeout, SocketAddress remoteSocketAddress, PlatformLogicalVersion serviceVersion) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Reading watch monitor response from the ServerEndpoint at [" + remoteSocketAddress + "]");
        }
        socketChannel.configureBlocking(true);
        long timeout = absoluteTimeout - SystemTime.timeMillis();
        if (timeout <= 0L) {
            throw new SocketTimeoutException("Timed out during monitoring connection [before read system response]");
        }
        socketChannel.socket().setSoTimeout((int)timeout);
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        RequestResponseTimeoutObserver.readFromSocketChannel(socketChannel, lengthBuffer, "read length", absoluteTimeout);
        lengthBuffer.flip();
        int length = lengthBuffer.getInt();
        timeout = absoluteTimeout - SystemTime.timeMillis();
        if (timeout <= 0L) {
            throw new SocketTimeoutException("Timed out during monitoring connection [during read system response]");
        }
        socketChannel.socket().setSoTimeout((int)timeout);
        ByteBuffer packetBuffer = ByteBuffer.allocate(length);
        RequestResponseTimeoutObserver.readFromSocketChannel(socketChannel, packetBuffer, "read packet", absoluteTimeout);
        GSByteArrayInputStream bis = new GSByteArrayInputStream(packetBuffer.array());
        MarshalInputStream mis = new MarshalInputStream(bis);
        ReplyPacket replyPacket = new ReplyPacket();
        try {
            replyPacket.readExternal(mis);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unexpected reply for watchdog monitoring request. " + e);
        }
        if (serviceVersion.lessThan(PlatformLogicalVersion.v9_6_0)) {
            boolean found = (Boolean)replyPacket.getResult();
            if (!found) {
                throw new IOException("No matching server channel invocation was found for this client at " + socketChannel.socket().getRemoteSocketAddress());
            }
        } else {
            ChannelEntry.State channelEntryState = ChannelEntry.State.fromCode((Integer)replyPacket.getResult());
            if (channelEntryState != ChannelEntry.State.PROGRESS) {
                throw new IOException("No matching server channel invocation was found for this client at " + socketChannel.socket().getRemoteSocketAddress() + ", server channel state: " + (Object)((Object)channelEntryState));
            }
        }
    }

    private void writeProtocolValidationHeader(SocketChannel socketChannel, long absoluteTimeout) throws IOException {
        ProtocolValidation.writeProtocolValidationHeader(socketChannel, absoluteTimeout - SystemTime.timeMillis());
    }

    private static void readFromSocketChannel(SocketChannel socketChannel, ByteBuffer buffer, String stage, long absoluteTimeout) throws IOException {
        try {
            while (0 < buffer.remaining()) {
                long timeout = absoluteTimeout - SystemTime.timeMillis();
                if (timeout <= 0L) {
                    throw new SocketTimeoutException("Timed out during monitoring connection [at stage '" + stage + "']");
                }
                socketChannel.read(buffer);
            }
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("[during " + stage + "]:" + e, e);
        }
    }
}

