/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.watchdog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.lrmi.ConnectionResource;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.nio.CPeer;
import com.gigaspaces.lrmi.nio.async.AsyncContext;
import com.gigaspaces.lrmi.nio.watchdog.RequestResponseTimeoutObserver;
import com.gigaspaces.lrmi.nio.watchdog.TimeoutObserver;
import com.gigaspaces.lrmi.nio.watchdog.Watchdog;
import com.gigaspaces.time.SystemTime;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class RequestTimeoutObserver
implements TimeoutObserver {
    protected static final int _INSPECT_TIMEOUT = Integer.getInteger("com.gs.transport_protocol.lrmi.inspect_timeout", 10000);
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi.watchdog");
    private final long _inspectResponseTimeout;

    public RequestTimeoutObserver(long requestTimeout) {
        this._inspectResponseTimeout = Long.getLong("com.gs.transport_protocol.lrmi.inspect_response_timeout", Math.max(requestTimeout, (long)_INSPECT_TIMEOUT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeoutOccured(Collection<Watchdog.WatchedObject> bucket) throws Exception {
        SocketAddress serverAddress = null;
        long startInvocationVersion = -1L;
        try (SocketChannel socketChannel = null;){
            socketChannel = SocketChannel.open();
            LRMIUtilities.initNewSocketProperties(socketChannel);
            Socket newSock = socketChannel.socket();
            Watchdog.WatchedObject watched = bucket.iterator().next();
            startInvocationVersion = watched.getVersion();
            serverAddress = watched.getSocket().socket().getRemoteSocketAddress();
            if (serverAddress == null) {
                throw new IOException("Watched socket was already closed: " + watched.getSocket().socket());
            }
            int localPort = watched.getSocket().socket().getLocalPort();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Attempting to create a new socket to the ServerEndPoint [" + serverAddress + "], local port[" + localPort + "]");
            }
            socketChannel.configureBlocking(true);
            long absoluteTimeout = SystemTime.timeMillis() + this._inspectResponseTimeout;
            newSock.connect(serverAddress, _INSPECT_TIMEOUT);
            this.handleOpenSocket(socketChannel, localPort, absoluteTimeout, watched.getClient());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.getValidConnectionMessage(serverAddress));
            }
            watched.startWatch();
        }
    }

    protected void handleOpenSocket(SocketChannel socketChannel, int watchedObjectLocalPort, long absoluteTimeout, ConnectionResource connectionResource) throws IOException {
    }

    protected String getValidConnectionMessage(SocketAddress serverAddress) {
        return "Established new connection with the ServerEndPoint [" + serverAddress + "], assuming connection is valid";
    }

    protected String getInvalidConnectionMessage(SocketAddress serverAddress, SocketChannel watchedSocketChannel, Watchdog.WatchedObject watched) {
        return "The ServerEndPoint [" + serverAddress + "] is not reachable (timeout [" + _INSPECT_TIMEOUT + "]); closing invalid connection with local address [" + this.getLocalAddressString(watchedSocketChannel) + "]" + RequestTimeoutObserver.getWatchedObjectInvocationMessage(watched);
    }

    protected String getFailureToCloseInvalidConnectionMessage(SocketAddress serverAddress, SocketChannel watchedSocketChannel) {
        return "A connection to the ServerEndPoint [" + watchedSocketChannel.socket().getRemoteSocketAddress() + "] that is not reachable, could not be closed. ";
    }

    protected String getLocalAddressString(SocketChannel socketChannel) {
        SocketAddress localSocketAddress;
        Socket socket;
        String localAddress = "not connected";
        if (socketChannel != null && (socket = socketChannel.socket()) != null && (localSocketAddress = socket.getLocalSocketAddress()) != null) {
            localAddress = localSocketAddress.toString();
        }
        return localAddress;
    }

    protected Level getCloseConnectionLoggingLevel() {
        return Level.FINE;
    }

    private void close(Collection<Watchdog.WatchedObject> bucket, SocketAddress serverAddress, Exception e, long originalInvocationVersion) throws IOException {
        for (Watchdog.WatchedObject watched : bucket) {
            long currentWatchedInvocationVersion = watched.getVersion();
            if (!RequestResponseTimeoutObserver.DISABLE_RESPONSE_WATCH && currentWatchedInvocationVersion > originalInvocationVersion) {
                if (!_logger.isLoggable(Level.FINER)) continue;
                _logger.log(Level.FINER, "Not closing invalid connection as current invocation version does not match original invocation version. [original version=" + originalInvocationVersion + ", current version=" + currentWatchedInvocationVersion + "original message [" + this.getInvalidConnectionMessage(serverAddress, watched.getSocket(), watched) + "[" + e + "]]");
                continue;
            }
            try {
                watched.stopWatch();
                watched.setException(e);
                Level closeConnectionLoggingLevel = this.getCloseConnectionLoggingLevel();
                if (_logger.isLoggable(closeConnectionLoggingLevel)) {
                    String invalidConnectionMessage = this.getInvalidConnectionMessage(serverAddress, watched.getSocket(), watched);
                    _logger.log(closeConnectionLoggingLevel, invalidConnectionMessage + "[" + e + "]", e);
                }
                if (watched.getSocket().isBlocking()) {
                    watched.getSocket().close();
                    continue;
                }
                AsyncContext context = ((CPeer)watched.getClient()).getAsyncContext();
                if (context == null) continue;
                context.setSelectionKey(null);
                context.close(new ClosedChannelException());
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, this.getFailureToCloseInvalidConnectionMessage(serverAddress, watched.getSocket()), ex);
            }
        }
    }

    protected static String getWatchedObjectInvocationMessage(Watchdog.WatchedObject watched) {
        return StringUtils.hasText(watched.getMonitoringId()) ? " [ remote invocation of: " + watched.getMonitoringId() + "] " : "";
    }
}

