/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.watchdog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.config.lrmi.nio.NIOConfiguration;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.lrmi.ConnectionResource;
import com.gigaspaces.lrmi.nio.watchdog.IdleConnectionTimeoutObserver;
import com.gigaspaces.lrmi.nio.watchdog.RequestResponseTimeoutObserver;
import com.gigaspaces.lrmi.nio.watchdog.RequestTimeoutObserver;
import com.gigaspaces.lrmi.nio.watchdog.TimeoutObserver;
import com.j_spaces.core.service.ServiceConfigLoader;
import java.lang.ref.WeakReference;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class Watchdog
extends GSThread {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi.watchdog");
    private static final int MAX_RESOLUTION = 100;
    private static final int MIN_RESOLUTION = 1;
    private static final String WATCHDOG = "Watchdog";
    private static final int UNWATCHED = -1;
    private static ITransportConfig _config;
    private static Watchdog _watchdog;
    private static boolean _shutdown;
    private final WatchdogGroup[] _groups = new WatchdogGroup[Group.values().length];

    public static synchronized WatchdogGroup getGroup(Group group) {
        if (_watchdog == null) {
            Watchdog.initWatchdog();
        }
        return Watchdog._watchdog._groups[group.ordinal()];
    }

    private static void initWatchdog() {
        if (_shutdown) {
            return;
        }
        if (null == _config) {
            _config = ServiceConfigLoader.getTransportConfiguration();
        }
        int timeoutResolution = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.timeout_resolution", "10"));
        boolean protocolValidationEnabled = ((NIOConfiguration)_config).isProtocolValidationEnabled();
        _watchdog = new Watchdog(WATCHDOG, _config.getWatchdogRequestTimeout(), _config.getWatchdogListeningTimeout(), _config.getWatchdogIdleConnectionTimeout(), timeoutResolution, protocolValidationEnabled);
        _watchdog.start();
    }

    public static synchronized void shutdown() {
        _shutdown = true;
        Watchdog watchdog = _watchdog;
        if (watchdog != null) {
            watchdog.interrupt();
        }
    }

    public Watchdog(String name, long requestTimeout, long listeningTimeout, long idleTimeout, int timeoutResolution, boolean protocolValidationEnabled) {
        super(name);
        int idleConnectionTimeout = Math.max((int)((double)listeningTimeout * 0.9), 1);
        int idleConnectionRetries = (int)(idleTimeout / (long)idleConnectionTimeout - 1L);
        timeoutResolution = this.inRange(timeoutResolution, 1, 100);
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config("Running watchdog with listening timeout=" + listeningTimeout + "sec,request timeout=" + requestTimeout + " millis,idle connection timeout=" + idleConnectionTimeout + " millis, retries=" + idleConnectionRetries + ", timeout resolution=" + timeoutResolution + "%.");
        }
        this._groups[Group.REQUEST_GROUP.ordinal()] = new WatchdogGroup(Group.REQUEST_GROUP.name(), requestTimeout, timeoutResolution, new RequestTimeoutObserver(requestTimeout));
        this._groups[Group.RESPONSE_GROUP.ordinal()] = new WatchdogGroup(Group.RESPONSE_GROUP.name(), requestTimeout, timeoutResolution, new RequestResponseTimeoutObserver(requestTimeout, protocolValidationEnabled));
        this._groups[Group.IDLE_GROUP.ordinal()] = new WatchdogGroup(Group.IDLE_GROUP.name(), idleConnectionTimeout, timeoutResolution, new IdleConnectionTimeoutObserver(idleConnectionRetries));
        this.setDaemon(true);
    }

    public void run() {
        long time = 0L;
        while (!this.isInterrupted()) {
            try {
                long nextTime = this.calcNextTime();
                Thread.sleep(nextTime - time);
                time = nextTime;
                for (int i = 0; i < this._groups.length; ++i) {
                    WatchdogGroup group = this._groups[i];
                    if (!group._doTimeout) continue;
                    group.timeout();
                }
            }
            catch (InterruptedException ie) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, this.getName() + " interrupted.", ie);
                }
                this.interrupt();
                break;
            }
            catch (Throwable t) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, "Unexpected exception in watchdog thread.", t);
            }
        }
    }

    private long calcNextTime() {
        WatchdogGroup group;
        int i;
        long nextTime = Long.MAX_VALUE;
        for (i = 0; i < this._groups.length; ++i) {
            group = this._groups[i];
            long gTime = group._time;
            long gWaitInterval = group._waitInterval;
            nextTime = Math.min(nextTime, gTime + gWaitInterval);
        }
        for (i = 0; i < this._groups.length; ++i) {
            group._doTimeout = nextTime == (group = this._groups[i])._time + group._waitInterval;
        }
        return nextTime;
    }

    private int inRange(int number, int min, int max) {
        int result = Math.min(number, max);
        result = Math.max(result, min);
        return result;
    }

    static final class ClientWatchedObject
    extends WatchedObject {
        int _retries;

        public ClientWatchedObject(WatchdogGroup group, ConnectionResource client) {
            super(group, null, client);
        }

        @Override
        public void stopWatch() {
            super.stopWatch();
            this._retries = 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ClientWatchedObject)) {
                return false;
            }
            return this._client.equals(((ClientWatchedObject)obj)._client);
        }

        @Override
        public int hashCode() {
            return this._client.hashCode();
        }
    }

    static final class ResponseWatchedObject
    extends WatchedObject {
        public ResponseWatchedObject(WatchdogGroup group, SocketChannel socket, ConnectionResource client) {
            super(group, socket, client);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    public static class WatchedObject {
        private int _time = -1;
        private final SocketChannel _socket;
        protected final ConnectionResource _client;
        private final WatchdogGroup _watchdogGroup;
        private Exception _exception;
        private volatile boolean _inUse = true;
        private String monitoringId;
        private long version = -1L;

        public WatchedObject(WatchdogGroup group, SocketChannel socket, ConnectionResource client) {
            this._watchdogGroup = group;
            this._socket = socket;
            this._client = client;
        }

        public int getTime() {
            return this._time;
        }

        public SocketChannel getSocket() {
            return this._socket;
        }

        public ConnectionResource getClient() {
            return this._client;
        }

        public void startWatch() {
            this._time = this._watchdogGroup._timerLogical;
        }

        public void stopWatch() {
            this._time = -1;
        }

        public Exception getException() {
            return this._exception;
        }

        public void setException(Exception exception) {
            this._exception = exception;
        }

        public boolean isInUse() {
            return this._inUse;
        }

        public void setInUse(boolean inUse) {
            this._inUse = inUse;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WatchedObject)) {
                return false;
            }
            SocketAddress myAddress = this._socket.socket().getRemoteSocketAddress();
            SocketAddress hisAddress = ((WatchedObject)obj)._socket.socket().getRemoteSocketAddress();
            if (myAddress != null) {
                return myAddress.equals(hisAddress);
            }
            return false;
        }

        public int hashCode() {
            SocketAddress address = this._socket.socket().getRemoteSocketAddress();
            if (null == address) {
                return 0;
            }
            return address.hashCode();
        }

        public String getMonitoringId() {
            return this.monitoringId;
        }

        public void setMonitoringId(String monitoringId) {
            this.monitoringId = monitoringId;
        }

        public long getVersion() {
            return this.version;
        }

        public void incrementVersion() {
            ++this.version;
        }
    }

    public final class WatchdogGroup {
        private final long _timeout;
        private long _time;
        private final TimeoutObserver _observer;
        private int _timerLogical;
        private final int _timeoutLogical;
        private final long _waitInterval;
        private final LinkedBlockingQueue<WeakReference<WatchedObject>> _watchedObjects = new LinkedBlockingQueue();
        private boolean _doTimeout = false;
        private final String _name;

        public WatchdogGroup(String name, long timeout, int timeoutResolution, TimeoutObserver observer) {
            this._name = name;
            this._observer = observer;
            this._timeout = timeout;
            this._waitInterval = (long)timeoutResolution * this._timeout / 100L;
            this._timeoutLogical = (int)(this._timeout / this._waitInterval);
        }

        private void timeout() throws Exception {
            int t = this._timerLogical++;
            this._time += this._waitInterval;
            HashMap<WatchedObject, Collection<WatchedObject>> watchedObjects = new HashMap<WatchedObject, Collection<WatchedObject>>();
            Iterator<WeakReference<WatchedObject>> iter = this._watchedObjects.iterator();
            while (iter.hasNext()) {
                WeakReference<WatchedObject> w = iter.next();
                WatchedObject watched = (WatchedObject)w.get();
                if (watched == null || !watched.isInUse()) {
                    iter.remove();
                    continue;
                }
                int time = watched.getTime();
                if (time == -1 || t - time < this._timeoutLogical) continue;
                if (_logger.isLoggable(Level.FINE)) {
                    Level logLevel = Level.FINEST;
                    if (Group.REQUEST_GROUP.name().equals(this._name) || Group.RESPONSE_GROUP.name().equals(this._name)) {
                        logLevel = Level.FINE;
                    } else if (Group.IDLE_GROUP.name().equals(this._name)) {
                        logLevel = Level.FINEST;
                    }
                    _logger.log(logLevel, this._name + " - " + (long)(t - time) * this._waitInterval + " Timeout occurred, max allowed = " + this._timeout);
                }
                this.add(watchedObjects, watched);
            }
            if (!watchedObjects.isEmpty()) {
                this.fireTimeoutOccured(watchedObjects);
            }
        }

        private void add(Map<WatchedObject, Collection<WatchedObject>> watchedObjects, WatchedObject watched) {
            Collection<WatchedObject> bucket = watchedObjects.get(watched);
            if (null == bucket) {
                bucket = new LinkedList<WatchedObject>();
                watchedObjects.put(watched, bucket);
            }
            bucket.add(watched);
        }

        protected void fireTimeoutOccured(Map<WatchedObject, Collection<WatchedObject>> watchedObjects) throws Exception {
            for (Collection<WatchedObject> bucket : watchedObjects.values()) {
                this._observer.timeoutOccured(bucket);
            }
        }

        public WatchedObject addRequestWatch(SocketChannel sock, ConnectionResource client) {
            return this.addWatch(new WatchedObject(this, sock, client));
        }

        public WatchedObject addResponseWatch(SocketChannel sock, ConnectionResource client) {
            return this.addWatch(new ResponseWatchedObject(this, sock, client));
        }

        public WatchedObject addIdleWatch(ConnectionResource client) {
            return this.addWatch(new ClientWatchedObject(this, client));
        }

        private WatchedObject addWatch(WatchedObject watched) {
            try {
                this._watchedObjects.put(new WeakReference<WatchedObject>(watched));
            }
            catch (InterruptedException e) {
                Watchdog.this.interrupt();
            }
            return watched;
        }

        public void removeWatch(WatchedObject watched) {
            watched.setInUse(false);
        }

        public long getTimeout() {
            return this._timeout;
        }
    }

    public static enum Group {
        REQUEST_GROUP,
        RESPONSE_GROUP,
        IDLE_GROUP;

    }
}

