/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.management.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.start.SystemInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ConnectionEndpointDetails
implements Externalizable,
Textualizable {
    private static final long serialVersionUID = 1L;
    public static final ConnectionEndpointDetails EMPTY = new ConnectionEndpointDetails(null, null, -1L, null);
    private String _hostName;
    private String _hostAddress;
    private long _processId;
    private PlatformLogicalVersion _version;

    public static ConnectionEndpointDetails create() {
        String hostname = SystemInfo.singleton().network().getHost().getHostName();
        String hostAddress = SystemInfo.singleton().network().getHost().getHostAddress();
        long pid = SystemInfo.singleton().os().processId();
        PlatformLogicalVersion version = PlatformLogicalVersion.getLogicalVersion();
        return new ConnectionEndpointDetails(hostname, hostAddress, pid, version);
    }

    public ConnectionEndpointDetails() {
    }

    public ConnectionEndpointDetails(String hostname, String hostAddress, long processId, PlatformLogicalVersion version) {
        this._hostName = hostname;
        this._hostAddress = hostAddress;
        this._processId = processId;
        this._version = version;
    }

    public ConnectionEndpointDetails createCopy(PlatformLogicalVersion newVersion) {
        return new ConnectionEndpointDetails(this._hostName, this._hostAddress, this._processId, newVersion);
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("hostName", this.getHostName());
        textualizer.append("hostAddress", this.getHostAddress());
        textualizer.append("pid", this.getProcessId());
        textualizer.append("version", this.getVersion());
    }

    public String getHostName() {
        return this._hostName;
    }

    public String getHostAddress() {
        return this._hostAddress;
    }

    public long getProcessId() {
        return this._processId;
    }

    public PlatformLogicalVersion getVersion() {
        return this._version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._hostAddress == null ? 0 : this._hostAddress.hashCode());
        result = 31 * result + (this._hostName == null ? 0 : this._hostName.hashCode());
        result = 31 * result + (int)(this._processId ^ this._processId >>> 32);
        result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionEndpointDetails other = (ConnectionEndpointDetails)obj;
        if (this._hostAddress == null ? other._hostAddress != null : !this._hostAddress.equals(other._hostAddress)) {
            return false;
        }
        if (this._hostName == null ? other._hostName != null : !this._hostName.equals(other._hostName)) {
            return false;
        }
        if (this._processId != other._processId) {
            return false;
        }
        return !(this._version == null ? other._version != null : !this._version.equals((Object)other._version));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._hostName);
        IOUtils.writeString(out, this._hostAddress);
        out.writeLong(this._processId);
        IOUtils.writeRepetitiveObject(out, this._version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._hostName = IOUtils.readString(in);
        this._hostAddress = IOUtils.readString(in);
        this._processId = in.readLong();
        this._version = (PlatformLogicalVersion)IOUtils.readRepetitiveObject(in);
    }
}

