/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metadata;

import com.gigaspaces.annotation.pojo.FifoSupport;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.DotNetStorageType;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PojoDefaults;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.metadata.TypeDesc;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexFactory;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.metadata.index.SpacePropertyIndex;
import com.gigaspaces.query.extension.SpaceQueryExtension;
import com.gigaspaces.query.extension.metadata.QueryExtensionPathInfo;
import com.gigaspaces.query.extension.metadata.impl.TypeQueryExtensionsImpl;
import com.j_spaces.core.client.ExternalEntry;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.jini.core.entry.Entry;

public class SpaceTypeDescriptorBuilder {
    private static final String ROOT_TYPE_NAME = Object.class.getName();
    private static final String DEFAULT_ID_PROPERTY_NAME = "_spaceId";
    private final String _typeName;
    private final SpaceTypeDescriptor _superTypeDescriptor;
    private final SortedMap<String, SpacePropertyDescriptor> _fixedProperties;
    private final Map<String, SpaceIndex> _indexes;
    private TypeQueryExtensionsImpl _queryExtensionsInfo;
    private Class<? extends Object> _objectClass;
    private Class<? extends SpaceDocument> _documentWrapperClass;
    private FifoSupport _fifoSupport;
    private Boolean _replicable;
    private Boolean _systemType;
    private String _idPropertyName;
    private boolean _idAutoGenerate;
    private String _routingPropertyName;
    private String _fifoGroupingPropertyPath;
    private Set<String> _fifoGroupingIndexes;
    private Boolean _supportsDynamicProperties;
    private Boolean _supportsOptimisticLocking;
    private StorageType _storageType;
    private Boolean _blobstoreEnabled;
    private String _sequenceNumberPropertyName;
    private boolean _sequenceNumberFromDocumentBuilder;

    public SpaceTypeDescriptorBuilder(String typeName) {
        this(typeName, null);
    }

    public SpaceTypeDescriptorBuilder(String typeName, SpaceTypeDescriptor superTypeDescriptor) {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("Argument cannot be null or empty - 'typeName'.");
        }
        if (typeName.equals(ROOT_TYPE_NAME)) {
            throw new IllegalArgumentException("Argument 'typeName' cannot be '" + ROOT_TYPE_NAME + "' - it is reserved for internal usage.");
        }
        this._typeName = typeName;
        this._superTypeDescriptor = superTypeDescriptor;
        this._fixedProperties = new TreeMap<String, SpacePropertyDescriptor>();
        this._indexes = new HashMap<String, SpaceIndex>();
        this._fifoGroupingIndexes = new HashSet<String>();
        this._storageType = StorageType.DEFAULT;
        this._blobstoreEnabled = true;
    }

    public SpaceTypeDescriptorBuilder(Class<?> type, SpaceTypeDescriptor superTypeDescriptor) {
        this(ObjectUtils.assertArgumentNotNull(type, "type").getName(), superTypeDescriptor);
        int numOfSuperFixedProperties;
        if (type.isInterface()) {
            throw new IllegalArgumentException("Creating SpaceTypeDescriptor for interfaces is not supported.");
        }
        if (type.isArray()) {
            throw new IllegalArgumentException("Creating SpaceTypeDescriptor for arrays is not supported.");
        }
        if (type.isEnum()) {
            throw new IllegalArgumentException("Creating SpaceTypeDescriptor for enumerations is not supported.");
        }
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Creating SpaceTypeDescriptor for primitive types is not supported.");
        }
        if (Entry.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Creating SpaceTypeDescriptor for types implementing 'net.jini.core.entry.Entry' is not supported.");
        }
        Class<?> superType = type.getSuperclass();
        if (superType != null && superType.getName().equals(ROOT_TYPE_NAME)) {
            superType = null;
        }
        if (superTypeDescriptor != null && superTypeDescriptor.getTypeName().equals(ROOT_TYPE_NAME)) {
            superTypeDescriptor = null;
        }
        if (superType == null && superTypeDescriptor != null) {
            throw new IllegalArgumentException("Type '" + type.getName() + "' has no super class, but superTypeDescriptor is not null.");
        }
        if (superType != null) {
            if (superTypeDescriptor == null) {
                throw new IllegalArgumentException("Type '" + type.getName() + "' has super class '" + superType.getName() + "', but superTypeDescriptor is null.");
            }
            if (!superType.equals(superTypeDescriptor.getObjectClass())) {
                throw new IllegalArgumentException("Type '" + type.getName() + "' has super class '" + superType.getName() + "', but superTypeDescriptor is of type '" + superTypeDescriptor.getTypeName() + "'.");
            }
        }
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(type);
        int numOfFixedProperties = typeInfo.getNumOfSpaceProperties();
        for (int i = numOfSuperFixedProperties = superTypeDescriptor == null ? 0 : superTypeDescriptor.getNumOfFixedProperties(); i < numOfFixedProperties; ++i) {
            SpacePropertyInfo property = typeInfo.getProperty(i);
            this.addFixedProperty(property.getName(), property.getType().getName());
        }
        for (SpaceIndex index : typeInfo.getIndexes().values()) {
            if (superTypeDescriptor != null && superTypeDescriptor.getIndexes().containsKey(index.getName())) continue;
            this.addIndex(index);
        }
        this._objectClass = type;
        this._systemType = typeInfo.isSystemClass();
        this._fifoSupport = typeInfo.getFifoSupport();
        this._replicable = typeInfo.isReplicate();
        this._supportsDynamicProperties = typeInfo.getDynamicPropertiesProperty() != null;
        this._supportsOptimisticLocking = typeInfo.getVersionProperty() != null;
        this._idPropertyName = typeInfo.getIdProperty() != null ? typeInfo.getIdProperty().getName() : null;
        this._idAutoGenerate = typeInfo.getIdAutoGenerate();
        this._routingPropertyName = typeInfo.getRoutingProperty() != null ? typeInfo.getRoutingProperty().getName() : null;
        this._blobstoreEnabled = typeInfo.isBlobstoreEnabled();
    }

    public SpaceTypeDescriptorBuilder documentWrapperClass(Class<? extends SpaceDocument> documentWrapperClass) {
        if (documentWrapperClass == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'documentWrapperClass'.");
        }
        this._documentWrapperClass = documentWrapperClass;
        return this;
    }

    public SpaceTypeDescriptorBuilder fifoSupport(FifoSupport fifoSupport) {
        if (fifoSupport == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'fifoSupport'.");
        }
        this._fifoSupport = fifoSupport;
        return this;
    }

    public SpaceTypeDescriptorBuilder replicable(boolean replicable) {
        this._replicable = replicable;
        return this;
    }

    public SpaceTypeDescriptorBuilder setBlobstoreEnabled(boolean blobstoreEnabled) {
        this._blobstoreEnabled = blobstoreEnabled;
        return this;
    }

    public SpaceTypeDescriptorBuilder supportsDynamicProperties(boolean supportsDynamicProperties) {
        this._supportsDynamicProperties = supportsDynamicProperties;
        return this;
    }

    public SpaceTypeDescriptorBuilder supportsOptimisticLocking(boolean supportsOptimisticLocking) {
        this._supportsOptimisticLocking = supportsOptimisticLocking;
        return this;
    }

    public SpaceTypeDescriptorBuilder storageType(StorageType storageType) {
        if (storageType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'storageType'.");
        }
        if (this._storageType != null && this._storageType != StorageType.DEFAULT && this._storageType != storageType) {
            throw new IllegalStateException("Cannot set storage type to '" + (Object)((Object)storageType) + "' - it was already set to '" + (Object)((Object)this._storageType) + "'.");
        }
        this._storageType = storageType;
        return this;
    }

    public SpaceTypeDescriptorBuilder addFixedProperty(String propertyName, Class<?> propertyType) {
        return this.addFixedProperty(propertyName, propertyType, SpaceDocumentSupport.DEFAULT, StorageType.DEFAULT);
    }

    public SpaceTypeDescriptorBuilder addFixedProperty(String propertyName, Class<?> propertyType, SpaceDocumentSupport documentSupport) {
        return this.addFixedProperty(propertyName, propertyType, documentSupport, StorageType.DEFAULT);
    }

    public SpaceTypeDescriptorBuilder addFixedProperty(String propertyName, Class<?> propertyType, StorageType storageType) {
        return this.addFixedProperty(propertyName, propertyType, SpaceDocumentSupport.DEFAULT, storageType);
    }

    public SpaceTypeDescriptorBuilder addFixedProperty(String propertyName, Class<?> propertyType, SpaceDocumentSupport documentSupport, StorageType storageType) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'propertyName'.");
        }
        if (propertyType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'propertyType'.");
        }
        if (documentSupport == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'documentSupport'.");
        }
        if (storageType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'storageType'.");
        }
        return this.addFixedProperty(new PropertyInfo(propertyName, propertyType, documentSupport, storageType));
    }

    public SpaceTypeDescriptorBuilder addFixedProperty(String propertyName, String propertyTypeName) {
        return this.addFixedProperty(propertyName, propertyTypeName, SpaceDocumentSupport.DEFAULT, StorageType.DEFAULT);
    }

    public SpaceTypeDescriptorBuilder addFixedProperty(String propertyName, String propertyTypeName, SpaceDocumentSupport documentSupport) {
        return this.addFixedProperty(propertyName, propertyTypeName, documentSupport, StorageType.DEFAULT);
    }

    public SpaceTypeDescriptorBuilder addFixedProperty(String propertyName, String propertyTypeName, SpaceDocumentSupport documentSupport, StorageType storageType) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'propertyName'.");
        }
        if (propertyTypeName == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'propertyTypeName'.");
        }
        if (documentSupport == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'documentSupport'.");
        }
        if (storageType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'storageType'.");
        }
        StorageType fixedStorageType = storageType;
        if (storageType == StorageType.DEFAULT) {
            fixedStorageType = this._storageType;
        }
        return this.addFixedProperty(new PropertyInfo(propertyName, propertyTypeName, documentSupport, fixedStorageType));
    }

    private SpaceTypeDescriptorBuilder addFixedProperty(SpacePropertyDescriptor property) {
        if (property == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'property'.");
        }
        if (this._fixedProperties.containsKey(property.getName())) {
            throw new IllegalArgumentException("Cannot add fixed property '" + property.getName() + "' - a property with the same name is already defined.");
        }
        if (this._superTypeDescriptor != null && this._superTypeDescriptor.getFixedPropertyPosition(property.getName()) != -1) {
            throw new IllegalArgumentException("Cannot add fixed property '" + property.getName() + "' - a property with the same name is defined in the super type.");
        }
        this._fixedProperties.put(property.getName(), property);
        return this;
    }

    public SpaceTypeDescriptorBuilder idProperty(String idPropertyName) {
        return this.idProperty(idPropertyName, false);
    }

    public SpaceTypeDescriptorBuilder idProperty(String idPropertyName, boolean autoGenerateId) {
        SpaceIndexType indexType = autoGenerateId ? SpaceIndexType.NONE : SpaceIndexType.EQUAL;
        return this.idProperty(idPropertyName, autoGenerateId, indexType);
    }

    public SpaceTypeDescriptorBuilder idProperty(String idPropertyName, boolean autoGenerateId, SpaceIndexType indexType) {
        if (idPropertyName == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'idPropertyName'.");
        }
        if (indexType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'indexType'.");
        }
        if (this._idPropertyName != null) {
            throw new IllegalStateException("Cannot set id property to '" + idPropertyName + "' - it was already set to '" + this._idPropertyName + "'.");
        }
        this._idPropertyName = idPropertyName;
        this._idAutoGenerate = autoGenerateId;
        this.addIndexIfNotExists(idPropertyName, indexType);
        return this;
    }

    public SpaceTypeDescriptorBuilder routingProperty(String routingPropertyName) {
        return this.routingProperty(routingPropertyName, SpaceIndexType.EQUAL);
    }

    public SpaceTypeDescriptorBuilder routingProperty(String routingPropertyName, SpaceIndexType indexType) {
        if (routingPropertyName == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'routingPropertyName'.");
        }
        if (indexType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'indexType'.");
        }
        if (this._routingPropertyName != null) {
            throw new IllegalStateException("Cannot set routing property to '" + routingPropertyName + "' - it was already set to '" + this._routingPropertyName + "'.");
        }
        this._routingPropertyName = routingPropertyName;
        this.addIndexIfNotExists(routingPropertyName, indexType);
        return this;
    }

    public SpaceTypeDescriptorBuilder fifoGroupingProperty(String fifoGroupingPropertyPath) {
        if (fifoGroupingPropertyPath == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'fifoGroupingPropertyPath'.");
        }
        if (this._fifoGroupingPropertyPath != null) {
            throw new IllegalStateException("Cannot set fifo grouping to '" + fifoGroupingPropertyPath + "' - it was already set to '" + this._fifoGroupingPropertyPath + "'.");
        }
        this.validateNoCollectionPath(fifoGroupingPropertyPath);
        this._fifoGroupingPropertyPath = fifoGroupingPropertyPath;
        return this;
    }

    public SpaceTypeDescriptorBuilder sequenceNumberProperty(String sequenceNumberPropertyName, boolean sequenceNumberFromDocumentBuilder) {
        if (sequenceNumberPropertyName == null || sequenceNumberPropertyName.length() == 0) {
            throw new IllegalArgumentException("Argument cannot be null/empty - 'sequenceNumberPropertyName'.");
        }
        if (this._sequenceNumberPropertyName != null && !sequenceNumberPropertyName.equals(this._sequenceNumberPropertyName)) {
            throw new IllegalStateException("Cannot set sequenceNumberPropertyName to '" + sequenceNumberPropertyName + "' - it was already set to '" + this._sequenceNumberPropertyName + "'.");
        }
        this.validateBasic(sequenceNumberPropertyName);
        this._sequenceNumberPropertyName = sequenceNumberPropertyName;
        this._sequenceNumberFromDocumentBuilder = sequenceNumberFromDocumentBuilder;
        return this;
    }

    public SpaceTypeDescriptorBuilder addFifoGroupingIndex(String fifoGroupingIndexPath) {
        if (fifoGroupingIndexPath == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'fifoGroupingIndexPath'.");
        }
        this.validateNoCollectionPath(fifoGroupingIndexPath);
        this._fifoGroupingIndexes.add(fifoGroupingIndexPath);
        return this;
    }

    public SpaceTypeDescriptorBuilder addPropertyIndex(String propertyName, SpaceIndexType indexType) {
        return this.addPropertyIndex(propertyName, indexType, false);
    }

    public SpaceTypeDescriptorBuilder addPropertyIndex(String propertyName, SpaceIndexType indexType, boolean unique) {
        return this.addIndex(SpaceIndexFactory.createPropertyIndex(propertyName, indexType, unique));
    }

    public SpaceTypeDescriptorBuilder addPathIndex(String path, SpaceIndexType indexType) {
        return this.addPathIndex(path, indexType, false);
    }

    public SpaceTypeDescriptorBuilder addPathIndex(String path, SpaceIndexType indexType, boolean unique) {
        return this.addIndex(SpaceIndexFactory.createPathIndex(path, indexType, unique));
    }

    @Deprecated
    public SpaceTypeDescriptorBuilder addCompoundIndex(String[] paths, SpaceIndexType indexType) {
        if (indexType != SpaceIndexType.BASIC && indexType != SpaceIndexType.EQUAL) {
            throw new UnsupportedOperationException("only EQUAL index type is supported for compoundindex");
        }
        return this.addCompoundIndex(paths, indexType, false);
    }

    public SpaceTypeDescriptorBuilder addCompoundIndex(String[] paths) {
        return this.addCompoundIndex(paths, SpaceIndexType.EQUAL, false);
    }

    @Deprecated
    public SpaceTypeDescriptorBuilder addCompoundIndex(String[] paths, SpaceIndexType indexType, boolean unique) {
        if (indexType != SpaceIndexType.BASIC && indexType != SpaceIndexType.EQUAL) {
            throw new UnsupportedOperationException("only BASIC index type is supported for compoundindex");
        }
        return this.addIndex(SpaceIndexFactory.createCompoundIndex(paths, indexType, null, unique));
    }

    public SpaceTypeDescriptorBuilder addCompoundIndex(String[] paths, boolean unique) {
        return this.addIndex(SpaceIndexFactory.createCompoundIndex(paths, SpaceIndexType.EQUAL, null, unique));
    }

    public SpaceTypeDescriptorBuilder addIndex(SpaceIndex index) {
        if (index == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'index'.");
        }
        if (this._indexes.containsKey(index.getName())) {
            throw new IllegalArgumentException("Cannot add index '" + index.getName() + "' - an index with the same name is already defined.");
        }
        if (this._superTypeDescriptor != null && this._superTypeDescriptor.getIndexes().containsKey(index.getName())) {
            throw new IllegalArgumentException("Cannot add index '" + index.getName() + "' - an index with the same name is defined in the super type.");
        }
        this._indexes.put(index.getName(), index);
        return this;
    }

    private void addIndexIfNotExists(String propertyName, SpaceIndexType indexType) {
        if (indexType != SpaceIndexType.NONE) {
            SpaceIndex index = this._indexes.get(propertyName);
            if (index == null) {
                this.addPropertyIndex(propertyName, indexType);
            } else if (!SpaceTypeDescriptorBuilder.isEquivalent(index.getIndexType(), indexType)) {
                throw new IllegalArgumentException("Cannot add index '" + index.getName() + "' as " + (Object)((Object)indexType) + " - it's already indexed as " + (Object)((Object)index.getIndexType()));
            }
        }
    }

    private static boolean isEquivalent(SpaceIndexType a, SpaceIndexType b) {
        if (a == b) {
            return true;
        }
        if (!(a != SpaceIndexType.BASIC && a != SpaceIndexType.EQUAL || b != SpaceIndexType.BASIC && b != SpaceIndexType.EQUAL)) {
            return true;
        }
        return !(a != SpaceIndexType.EXTENDED && a != SpaceIndexType.EQUAL_AND_ORDERED || b != SpaceIndexType.EXTENDED && b != SpaceIndexType.EQUAL_AND_ORDERED);
    }

    public SpaceTypeDescriptorBuilder addQueryExtensionInfo(String path, Class<? extends Annotation> queryExtensionAnnotation) {
        if (!queryExtensionAnnotation.isAnnotationPresent(SpaceQueryExtension.class)) {
            throw new IllegalArgumentException("Annotation " + queryExtensionAnnotation + " is not a space query extension annotation");
        }
        this.createQueryExtensionInfoIfNeeded();
        this._queryExtensionsInfo.add(path, queryExtensionAnnotation);
        return this;
    }

    public SpaceTypeDescriptorBuilder addQueryExtensionInfo(String path, QueryExtensionPathInfo pathInfo) {
        this.createQueryExtensionInfoIfNeeded();
        this._queryExtensionsInfo.add(path, pathInfo);
        return this;
    }

    private void createQueryExtensionInfoIfNeeded() {
        if (this._queryExtensionsInfo == null) {
            this._queryExtensionsInfo = new TypeQueryExtensionsImpl();
        }
    }

    public SpaceTypeDescriptor create() {
        EntryType entryType;
        this.applyDefaults();
        String[] superTypesNames = SpaceTypeDescriptorBuilder.getSuperTypesNames(this._typeName, this._superTypeDescriptor);
        PropertyInfo[] fixedProperties = SpaceTypeDescriptorBuilder.initFixedProperties(this._fixedProperties, this._superTypeDescriptor, this._storageType);
        Map<String, SpaceIndex> indexes = SpaceTypeDescriptorBuilder.initIndexes(this._indexes, fixedProperties, this._idPropertyName, this._superTypeDescriptor);
        String codeBase = null;
        EntryType entryType2 = entryType = this._objectClass == null ? EntryType.DOCUMENT_JAVA : EntryType.OBJECT_JAVA;
        if (!this._supportsDynamicProperties.booleanValue()) {
            SpaceTypeDescriptorBuilder.validatePropertyExists(this._idPropertyName, fixedProperties);
            SpaceTypeDescriptorBuilder.validatePropertyExists(this._routingPropertyName, fixedProperties);
        }
        return new TypeDesc(this._typeName, codeBase, superTypesNames, fixedProperties, this._supportsDynamicProperties, indexes, this._idPropertyName, this._idAutoGenerate, null, this._routingPropertyName, this._fifoGroupingPropertyPath, this._fifoGroupingIndexes, this._systemType, this._fifoSupport, this._replicable, this._supportsOptimisticLocking, this._storageType, entryType, this._objectClass, ExternalEntry.class, this._documentWrapperClass, null, DotNetStorageType.NULL, this._blobstoreEnabled, this._sequenceNumberPropertyName, this._queryExtensionsInfo);
    }

    private void applyDefaults() {
        if (this._systemType == null) {
            if (this._superTypeDescriptor != null) {
                this._systemType = SpaceTypeDescriptorBuilder.getInternalTypeDesc(this._superTypeDescriptor).isSystemType();
            }
            if (this._systemType == null) {
                this._systemType = false;
            }
        }
        if (this._fifoSupport == null) {
            if (this._superTypeDescriptor != null) {
                this._fifoSupport = this._superTypeDescriptor.getFifoSupport();
            }
            if (this._fifoSupport == null) {
                this._fifoSupport = PojoDefaults.FIFO_SUPPORT;
            }
        }
        if (this._replicable == null) {
            if (this._superTypeDescriptor != null) {
                this._replicable = this._superTypeDescriptor.isReplicable();
            }
            if (this._replicable == null) {
                this._replicable = true;
            }
        }
        if (this._blobstoreEnabled == null) {
            if (this._superTypeDescriptor != null) {
                this._blobstoreEnabled = this._superTypeDescriptor.isBlobstoreEnabled();
            }
            if (this._blobstoreEnabled == null) {
                this._blobstoreEnabled = true;
            }
        }
        if (this._supportsDynamicProperties == null) {
            if (this._superTypeDescriptor != null) {
                this._supportsDynamicProperties = this._superTypeDescriptor.supportsDynamicProperties();
            }
            if (this._supportsDynamicProperties == null) {
                this._supportsDynamicProperties = true;
            }
        }
        if (this._supportsOptimisticLocking == null) {
            if (this._superTypeDescriptor != null) {
                this._supportsOptimisticLocking = this._superTypeDescriptor.supportsOptimisticLocking();
            }
            if (this._supportsOptimisticLocking == null) {
                this._supportsOptimisticLocking = false;
            }
        }
        if (this._documentWrapperClass == null) {
            if (this._superTypeDescriptor != null) {
                this._documentWrapperClass = this._superTypeDescriptor.getDocumentWrapperClass();
            }
            if (this._documentWrapperClass == null) {
                this._documentWrapperClass = SpaceDocument.class;
            }
        }
        if (this._idPropertyName == null) {
            if (this._superTypeDescriptor != null) {
                this._idPropertyName = this._superTypeDescriptor.getIdPropertyName();
                this._idAutoGenerate = SpaceTypeDescriptorBuilder.getInternalTypeDesc(this._superTypeDescriptor).isAutoGenerateId();
            }
            if (this._idPropertyName == null && this._objectClass == null) {
                this._idPropertyName = DEFAULT_ID_PROPERTY_NAME;
                this._idAutoGenerate = true;
            }
        }
        if (this._idPropertyName != null && !this.isFixedProperty(this._idPropertyName)) {
            this.addFixedProperty(this._idPropertyName, Object.class);
        }
        if (this._routingPropertyName == null && this._superTypeDescriptor != null) {
            this._routingPropertyName = this._superTypeDescriptor.getRoutingPropertyName();
        }
        if (this._routingPropertyName != null && !this.isFixedProperty(this._routingPropertyName)) {
            this.addFixedProperty(this._routingPropertyName, Object.class);
        }
        if (this._superTypeDescriptor != null) {
            if (this._storageType != StorageType.DEFAULT) {
                throw new IllegalStateException("Cannot declare class's storage type [" + (Object)((Object)this._storageType) + "] if one has already been defined in the super class [" + (Object)((Object)this._superTypeDescriptor.getStorageType()) + "].");
            }
            this._storageType = this._superTypeDescriptor.getStorageType();
            if (this._fifoGroupingPropertyPath != null && this._superTypeDescriptor.getFifoGroupingPropertyPath() != null) {
                throw new IllegalStateException("Cannot declare a fifo grouping property if one has already been defined in the super class [" + this._superTypeDescriptor.getFifoGroupingPropertyPath() + "].");
            }
            if (this._fifoGroupingPropertyPath == null) {
                this._fifoGroupingPropertyPath = this._superTypeDescriptor.getFifoGroupingPropertyPath();
            }
            for (String fifoGroupingIndexName : this._superTypeDescriptor.getFifoGroupingIndexesPaths()) {
                this._fifoGroupingIndexes.add(fifoGroupingIndexName);
            }
            String superSN = null;
            if (this._superTypeDescriptor.hasSequenceNumber()) {
                superSN = this._superTypeDescriptor.getFixedProperty(this._superTypeDescriptor.getSequenceNumberFixedPropertyID()).getName();
            }
            if (this._sequenceNumberPropertyName != null && superSN != null) {
                throw new IllegalStateException("Cannot declare a sequence number property if one has already been defined in the super class [" + superSN + "].");
            }
            if (this._sequenceNumberPropertyName == null) {
                this._sequenceNumberPropertyName = superSN;
            }
        } else if (this._storageType == StorageType.DEFAULT) {
            this._storageType = StorageType.OBJECT;
        }
        if (this._sequenceNumberPropertyName != null && this._sequenceNumberFromDocumentBuilder && !this.isFixedProperty(this._sequenceNumberPropertyName)) {
            this.addFixedProperty(this._sequenceNumberPropertyName, Long.class);
        }
    }

    private boolean isFixedProperty(String propertyName) {
        if (this._fixedProperties.containsKey(propertyName)) {
            return true;
        }
        return this._superTypeDescriptor != null && this._superTypeDescriptor.getFixedProperty(propertyName) != null;
    }

    private static void validatePropertyExists(String propertyName, PropertyInfo[] properties) {
        if (propertyName == null || propertyName.length() == 0) {
            return;
        }
        for (PropertyInfo property : properties) {
            if (!property.getName().equals(propertyName)) continue;
            return;
        }
        throw new IllegalArgumentException("No such property - '" + propertyName + "'.");
    }

    private static String[] getSuperTypesNames(String typeName, SpaceTypeDescriptor superTypeDescriptor) {
        if (typeName.equals(ROOT_TYPE_NAME)) {
            return new String[]{ROOT_TYPE_NAME, ROOT_TYPE_NAME};
        }
        if (superTypeDescriptor == null || superTypeDescriptor.getTypeName().equals(ROOT_TYPE_NAME)) {
            return new String[]{typeName, ROOT_TYPE_NAME};
        }
        String[] superSuperTypesNames = SpaceTypeDescriptorBuilder.getInternalTypeDesc(superTypeDescriptor).getSuperClassesNames();
        String[] superTypesNames = new String[superSuperTypesNames.length + 1];
        superTypesNames[0] = typeName;
        for (int i = 1; i < superTypesNames.length; ++i) {
            superTypesNames[i] = superSuperTypesNames[i - 1];
        }
        return superTypesNames;
    }

    private void validateNoCollectionPath(String path) {
        if (path != null && path.length() != 0 && path.indexOf("[*]") != -1) {
            throw new IllegalArgumentException("[" + path + "] collection index cannot be fifo grouping index");
        }
    }

    private void validateBasic(String name) {
        if (name.indexOf("[*]") != -1 || name.indexOf(".") != -1) {
            throw new IllegalArgumentException("[" + name + "] collection/path cannot be sequence number property");
        }
    }

    private static PropertyInfo[] initFixedProperties(SortedMap<String, SpacePropertyDescriptor> properties, SpaceTypeDescriptor superTypeDesc, StorageType defaultStorageType) {
        int numOfSuperFixedProerties = superTypeDesc != null ? superTypeDesc.getNumOfFixedProperties() : 0;
        int numOfFixedProerties = properties != null ? properties.size() : 0;
        PropertyInfo[] mergedProperties = new PropertyInfo[numOfSuperFixedProerties + numOfFixedProerties];
        int pos = 0;
        if (superTypeDesc != null) {
            for (int i = 0; i < numOfSuperFixedProerties; ++i) {
                mergedProperties[pos++] = (PropertyInfo)superTypeDesc.getFixedProperty(i);
            }
        }
        if (properties != null) {
            for (Map.Entry<String, SpacePropertyDescriptor> pair : properties.entrySet()) {
                PropertyInfo property = (PropertyInfo)pair.getValue();
                mergedProperties[pos++] = property;
            }
        }
        return mergedProperties;
    }

    private static Map<String, SpaceIndex> initIndexes(Map<String, SpaceIndex> indexes, PropertyInfo[] fixedProperties, String idPropertyName, SpaceTypeDescriptor superTypeDescriptor) {
        HashMap<String, SpaceIndex> result = new HashMap<String, SpaceIndex>(indexes.size());
        for (SpaceIndex index : indexes.values()) {
            int position = SpaceTypeDescriptorBuilder.getPositionOf(index.getName(), fixedProperties);
            if (position != -1) {
                boolean isUnique = ((ISpaceIndex)index).isUnique() || index.getName().equals(idPropertyName);
                index = new SpacePropertyIndex(index.getName(), index.getIndexType(), isUnique, position);
            }
            result.put(index.getName(), index);
        }
        if (superTypeDescriptor != null) {
            for (SpaceIndex index : superTypeDescriptor.getIndexes().values()) {
                result.put(index.getName(), index);
            }
        }
        return result;
    }

    private static int getPositionOf(String propertyName, SpacePropertyDescriptor[] properties) {
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].getName().equals(propertyName)) continue;
            return i;
        }
        return -1;
    }

    private static ITypeDesc getInternalTypeDesc(SpaceTypeDescriptor typeDesc) {
        return (ITypeDesc)typeDesc;
    }
}

