/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metadata;

public enum StorageType {
    DEFAULT,
    OBJECT,
    BINARY,
    COMPRESSED;

    private static final int OBJECT_CODE = 0;
    private static final int BINARY_CODE = 1;
    private static final int FULL_CODE = 2;
    private static final int COMPRESSED_CODE = 3;

    public static StorageType fromCode(int code) {
        switch (code) {
            case 0: {
                return OBJECT;
            }
            case 1: {
                return BINARY;
            }
            case 3: {
                return COMPRESSED;
            }
            case 2: {
                throw new IllegalArgumentException("StorageType FULL (2) is no longer supported - use " + (Object)((Object)BINARY) + " (" + 1 + ") instead");
            }
        }
        throw new IllegalArgumentException("Unsupported StorageType code: " + code);
    }

    public int getCode() {
        switch (this) {
            case OBJECT: {
                return 0;
            }
            case BINARY: {
                return 1;
            }
            case COMPRESSED: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unsupported StorageType: " + (Object)((Object)this));
    }
}

