/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metadata.index;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.SpaceIndexTypeHelper;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.serialization.AbstractExternalizable;
import com.gigaspaces.internal.server.storage.TemplateEntryData;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractSpaceIndex
extends AbstractExternalizable
implements ISpaceIndex {
    private static final long serialVersionUID = 1L;
    private String _name;
    private SpaceIndexType _indexType;
    private boolean _isUnique;
    private static final byte FLAG_VERSION = 1;
    private static final byte FLAG_UNIQUE = 2;

    public AbstractSpaceIndex() {
    }

    protected AbstractSpaceIndex(String indexName, SpaceIndexType indexType, boolean isUnique) {
        this._name = indexName;
        this._indexType = indexType;
        this._isUnique = isUnique;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public SpaceIndexType getIndexType() {
        return this._indexType;
    }

    @Override
    public boolean isUnique() {
        return this._isUnique;
    }

    @Override
    public void setUnique(boolean val) {
        this._isUnique = val;
    }

    @Override
    public boolean isMultiValuePerEntryIndex() {
        return false;
    }

    @Override
    public ISpaceIndex.MultiValuePerEntryIndexTypes getMultiValueIndexType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompoundIndex() {
        return false;
    }

    @Override
    public ISpaceCompoundIndexSegment[] getCompoundIndexSegments() {
        throw new UnsupportedOperationException();
    }

    public int getNumSegments() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSpaceIndex other = (AbstractSpaceIndex)obj;
        return !(this._name == null ? other._name != null : !this._name.equals(other._name));
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    private final void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        boolean bl = this._isUnique = (flags & 2) != 0;
        if ((flags & 1) != 0) {
            PlatformLogicalVersion platformLogicalVersion = (PlatformLogicalVersion)in.readObject();
        }
        this._name = IOUtils.readString(in);
        this._indexType = SpaceIndexTypeHelper.fromCode(in.readByte());
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    private final void serialize(ObjectOutput out) throws IOException {
        byte flags = this.buildFlags();
        out.writeByte(flags);
        if ((flags & 1) != 0) {
            PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
            out.writeObject(version);
        }
        IOUtils.writeString(out, this._name);
        out.writeByte(SpaceIndexTypeHelper.toCode(this._indexType));
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    private byte buildFlags() {
        byte flags = 0;
        flags = (byte)(flags | 1);
        if (this._isUnique) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }

    protected Object getIndexValueFromCustomIndex(ServerEntry entry) {
        TemplateEntryData templateHolder = (TemplateEntryData)entry;
        if (templateHolder.getCustomIndexes() != null) {
            for (IQueryIndexScanner scanner : templateHolder.getCustomIndexes()) {
                if (!this.getName().equals(scanner.getIndexName())) continue;
                return scanner.supportsTemplateIndex() ? scanner.getIndexValue() : null;
            }
        }
        return null;
    }

    public String toString() {
        return "SpaceIndex[name=" + this._name + ", type=" + (Object)((Object)this._indexType) + ", unique=" + this._isUnique + "]";
    }
}

