/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metadata.index;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryCompoundIndexGetter;
import com.gigaspaces.metadata.index.CustomIndex;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.gigaspaces.metadata.index.SpaceIndexFactory;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class CompoundIndex
extends CustomIndex {
    private static final long serialVersionUID = 1L;
    private ISpaceCompoundIndexSegment[] _segments;

    public CompoundIndex() {
    }

    public CompoundIndex(String[] paths) {
        super(SpaceIndexFactory.createCompoundIndexName(paths), new SpaceEntryCompoundIndexGetter(SpaceIndexFactory.createCompoundSegmentsDefinition(paths)), false, SpaceIndexType.EQUAL);
        this._segments = ((SpaceEntryCompoundIndexGetter)this._indexValueGetter).getSegments();
    }

    CompoundIndex(String indexName, SpaceIndexType indexType, ISpaceCompoundIndexSegment[] segments, boolean unique) {
        super(indexName, new SpaceEntryCompoundIndexGetter(segments), unique, indexType);
        this._segments = segments;
    }

    @Override
    public boolean isCompoundIndex() {
        return true;
    }

    @Override
    public ISpaceCompoundIndexSegment[] getCompoundIndexSegments() {
        return this._segments;
    }

    @Override
    public int getNumSegments() {
        return this._segments.length;
    }

    @Override
    public Object getIndexValueForTemplate(ServerEntry entry) {
        return this._indexValueGetter.getValue(entry);
    }

    @Override
    public Object getIndexValue(ServerEntry entry) {
        return this._indexValueGetter.getValue(entry);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return false;
        }
        CompoundIndex other = (CompoundIndex)obj;
        return Arrays.equals(this._segments, other.getCompoundIndexSegments());
    }

    public boolean isEquivalent(CompoundIndex other) {
        return Arrays.equals(this._segments, other.getCompoundIndexSegments());
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._segments = (ISpaceCompoundIndexSegment[])IOUtils.readObject(in);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._segments = (ISpaceCompoundIndexSegment[])IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._segments);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeObject(out, this._segments);
    }
}

