/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metadata.index;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.valuegetter.ISpaceValueGetter;
import com.gigaspaces.metadata.index.AbstractSpaceIndex;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class CustomIndex
extends AbstractSpaceIndex {
    private static final long serialVersionUID = 1L;
    protected ISpaceValueGetter<ServerEntry> _indexValueGetter;

    public CustomIndex() {
    }

    public CustomIndex(String indexName, ISpaceValueGetter<ServerEntry> indexValueGetter, boolean isUnique, SpaceIndexType indexType) {
        super(indexName, indexType, isUnique);
        this._indexValueGetter = indexValueGetter;
    }

    @Override
    public Object getIndexValue(ServerEntry entry) {
        return this._indexValueGetter.getValue(entry);
    }

    @Override
    public ISpaceIndex.IndexOriginTypes getIndexOriginType() {
        return ISpaceIndex.IndexOriginTypes.CUSTOM;
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._indexValueGetter = (ISpaceValueGetter)IOUtils.readObject(in);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._indexValueGetter = (ISpaceValueGetter)IOUtils.readNullableSwapExternalizableObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._indexValueGetter);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeNullableSwapExternalizableObject(out, this._indexValueGetter);
    }

    @Override
    public Object getIndexValueForTemplate(ServerEntry entry) {
        return this.getIndexValueFromCustomIndex(entry);
    }
}

