/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metadata.index;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPropertyGetter;
import com.gigaspaces.metadata.index.AbstractCompoundIndexSegment;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class PropertyCompoundIndexSegment
extends AbstractCompoundIndexSegment {
    private static final long serialVersionUID = 1L;
    private SpaceEntryPropertyGetter _indexValueGetter;

    public PropertyCompoundIndexSegment() {
    }

    public PropertyCompoundIndexSegment(int segmentPos, String name) {
        super(segmentPos, name);
        this._indexValueGetter = new SpaceEntryPropertyGetter(name);
    }

    @Override
    public Object getSegmentValue(ServerEntry entry) {
        return this._indexValueGetter.getValue(entry);
    }

    @Override
    public boolean isPropertySegment() {
        return true;
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._indexValueGetter = (SpaceEntryPropertyGetter)IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._indexValueGetter);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeNullableSwapExternalizableObject(out, this._indexValueGetter);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._indexValueGetter = (SpaceEntryPropertyGetter)IOUtils.readNullableSwapExternalizableObject(in);
    }
}

