/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metadata.index;

import com.gigaspaces.internal.metadata.SpaceCollectionIndex;
import com.gigaspaces.metadata.index.CompoundIndex;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.gigaspaces.metadata.index.PathCompoundIndexSegment;
import com.gigaspaces.metadata.index.PropertyCompoundIndexSegment;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.metadata.index.SpacePathIndex;
import java.util.HashSet;

public class SpaceIndexFactory {
    public static SpaceIndex createPropertyIndex(String propertyName, SpaceIndexType indexType) {
        return SpaceIndexFactory.createPropertyIndex(propertyName, indexType, false);
    }

    public static SpaceIndex createPropertyIndex(String propertyName, SpaceIndexType indexType, boolean unique) {
        return SpaceIndexFactory.createPathIndex_Impl(propertyName, indexType, unique);
    }

    public static SpaceIndex createPathIndex(String path, SpaceIndexType indexType) {
        return SpaceIndexFactory.createPathIndex(path, indexType, false);
    }

    public static SpaceIndex createPathIndex(String path, SpaceIndexType indexType, boolean unique) {
        return SpaceIndexFactory.createPathIndex_Impl(path, indexType, unique);
    }

    public static SpaceIndex createCompoundIndex(String[] paths) {
        return SpaceIndexFactory.createCompoundIndex(paths, SpaceIndexType.EQUAL, null, false);
    }

    public static SpaceIndex createCompoundIndex(String[] paths, SpaceIndexType indexType, String indexName, boolean unique) {
        return SpaceIndexFactory.createCompoundIndex_Impl(paths, indexType, indexName, unique);
    }

    private static SpaceIndex createPathIndex_Impl(String path, SpaceIndexType indexType, boolean unique) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Argument cannot be null or empty - 'path'.");
        }
        if (indexType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'indexType'.");
        }
        if (path.indexOf("[*]") != -1) {
            return new SpaceCollectionIndex(path, indexType, unique);
        }
        return new SpacePathIndex(path, indexType, unique);
    }

    private static SpaceIndex createCompoundIndex_Impl(String[] paths, SpaceIndexType indexType, String indexName, boolean unique) {
        if (indexType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'indexType'.");
        }
        ISpaceCompoundIndexSegment[] segments = SpaceIndexFactory.createCompoundSegmentsDefinition(paths);
        return new CompoundIndex(indexName != null ? indexName : SpaceIndexFactory.createCompoundIndexName(paths), indexType, segments, unique);
    }

    static ISpaceCompoundIndexSegment[] createCompoundSegmentsDefinition(String[] paths) {
        if (paths == null || paths.length < 2) {
            throw new IllegalArgumentException("Argument cannot be null or less than 2 elements - 'paths'.");
        }
        ISpaceCompoundIndexSegment[] segments = new ISpaceCompoundIndexSegment[paths.length];
        HashSet<String> pathsNames = new HashSet<String>();
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] == null || paths[i].length() == 0) {
                throw new IllegalArgumentException("Argument cannot be null or empty - path number " + (i + 1));
            }
            if (paths[i].indexOf("[*]") != -1) {
                throw new IllegalArgumentException("Argument cannot be a collection - path number " + (i + 1));
            }
            if (pathsNames.contains(paths[i])) {
                throw new IllegalArgumentException("Duplicate path name in compound index");
            }
            pathsNames.add(paths[i]);
            segments[i] = paths[i].indexOf(".") != -1 ? new PathCompoundIndexSegment(i + 1, paths[i]) : new PropertyCompoundIndexSegment(i + 1, paths[i]);
        }
        return segments;
    }

    static String createCompoundIndexName(String[] paths) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String path : paths) {
            if (!first) {
                sb.append("+");
            } else {
                first = false;
            }
            sb.append(path);
        }
        return sb.toString();
    }
}

