/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metadata.index;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPathGetter;
import com.gigaspaces.metadata.index.AbstractSpaceIndex;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class SpacePathIndex
extends AbstractSpaceIndex {
    private static final long serialVersionUID = 1L;
    private SpaceEntryPathGetter _indexValueGetter;

    public SpacePathIndex() {
    }

    public SpacePathIndex(String path, SpaceIndexType indexType, boolean unique) {
        super(path, indexType, unique);
        this._indexValueGetter = new SpaceEntryPathGetter(path);
    }

    @Override
    public Object getIndexValue(ServerEntry entry) {
        return this._indexValueGetter.getValue(entry);
    }

    @Override
    public ISpaceIndex.IndexOriginTypes getIndexOriginType() {
        return ISpaceIndex.IndexOriginTypes.PATH;
    }

    @Override
    public Object getIndexValueForTemplate(ServerEntry entry) {
        return this.getIndexValueFromCustomIndex(entry);
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._indexValueGetter = (SpaceEntryPathGetter)IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._indexValueGetter);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeNullableSwapExternalizableObject(out, this._indexValueGetter);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._indexValueGetter = (SpaceEntryPathGetter)IOUtils.readNullableSwapExternalizableObject(in);
    }
}

