/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metadata.index;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metadata.index.AbstractSpaceIndex;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class SpacePropertyIndex
extends AbstractSpaceIndex {
    private static final long serialVersionUID = 1L;
    private int _propertyPos;

    public SpacePropertyIndex() {
    }

    public SpacePropertyIndex(String name, SpaceIndexType type, boolean isUnique, int propertyPos) {
        super(name, type, isUnique);
        this._propertyPos = propertyPos;
    }

    @Override
    public Object getIndexValue(ServerEntry entry) {
        return entry.getFixedPropertyValue(this._propertyPos);
    }

    @Override
    public ISpaceIndex.IndexOriginTypes getIndexOriginType() {
        return ISpaceIndex.IndexOriginTypes.PROPERTY;
    }

    @Override
    public Object getIndexValueForTemplate(ServerEntry entry) {
        return this.getIndexValue(entry);
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._propertyPos = in.readInt();
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._propertyPos = in.readInt();
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        out.writeInt(this._propertyPos);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        out.writeInt(this._propertyPos);
    }
}

