/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metrics.DynamicMetricTag;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.metrics.MetricManager;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.metrics.MetricTags;
import java.util.Collections;
import java.util.Map;

@InternalApi
public class InternalMetricRegistrator
extends MetricRegistrator {
    private final MetricManager metricManager;
    private final String prefix;
    private final MetricTags tags;

    public InternalMetricRegistrator(MetricManager metricManager, String prefix, MetricTags tags) {
        this.metricManager = metricManager;
        this.prefix = prefix + metricManager.getSeparator();
        this.tags = tags;
    }

    @Override
    public MetricRegistrator extend(String prefix) {
        return this.extend(prefix, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    public MetricRegistrator extend(String prefix, Map<String, String> newTags, Map<String, DynamicMetricTag> newDynamicTags) {
        return new InternalMetricRegistrator(this.metricManager, this.prefix + prefix, this.tags.extend(newTags, newDynamicTags));
    }

    @Override
    public String toPath(String ... names) {
        String result = names[0];
        for (int i = 1; i < names.length; ++i) {
            result = result + this.metricManager.getSeparator() + names[i];
        }
        return result;
    }

    @Override
    public void register(String name, Metric metric) {
        this.metricManager.register(this.prefix + name, this.tags, metric);
    }

    @Override
    public void unregister(String name) {
        this.metricManager.unregister(this.prefix + name, this.tags);
    }

    @Override
    public void unregisterByPrefix(String prefix) {
        this.metricManager.unregisterByPrefix(this.prefix + prefix, this.tags);
    }

    @Override
    public void clear() {
        this.metricManager.unregisterByPrefix(this.prefix, this.tags);
    }
}

