/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.metrics.MetricGroupSnapshot;
import com.gigaspaces.metrics.ThroughputMetric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@InternalApi
public class MetricGroup {
    private final Map<String, Metric> metrics = new ConcurrentHashMap<String, Metric>();
    private final ConcurrentHashMap<String, Gauge> gauges = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LongCounter> counters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ThroughputMetric> tpMetrics = new ConcurrentHashMap();

    Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    public void register(String name, Metric metric) {
        if (this.metrics.containsKey(name)) {
            throw new IllegalArgumentException("A metric named " + name + " already exists");
        }
        this.metrics.put(name, metric);
        ConcurrentHashMap<String, Metric> metricMap = this.getMetricMapByType(metric);
        if (metricMap != null) {
            metricMap.put(name, metric);
        }
    }

    protected <T extends Metric> ConcurrentHashMap<String, T> getMetricMapByType(T metric) {
        if (metric instanceof Gauge) {
            return this.gauges;
        }
        if (metric instanceof LongCounter) {
            return this.counters;
        }
        if (metric instanceof ThroughputMetric) {
            return this.tpMetrics;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.gauges.isEmpty() && this.counters.isEmpty() && this.tpMetrics.isEmpty();
    }

    public MetricGroupSnapshot snapshot() {
        HashMap<String, Object> metricsValues = new HashMap<String, Object>(this.gauges.size() + this.counters.size() + this.tpMetrics.size());
        for (Map.Entry<String, Gauge> entry : this.gauges.entrySet()) {
            try {
                metricsValues.put(entry.getKey(), entry.getValue().getValue());
            }
            catch (Exception exception) {}
        }
        for (Map.Entry<String, Metric> entry : this.counters.entrySet()) {
            metricsValues.put(entry.getKey(), ((LongCounter)entry.getValue()).getCount());
        }
        for (Map.Entry<String, Metric> entry : this.tpMetrics.entrySet()) {
            metricsValues.put(entry.getKey(), ((ThroughputMetric)entry.getValue()).sampleThroughput());
        }
        return new MetricGroupSnapshot(metricsValues);
    }

    public void remove(String metricName) {
        ConcurrentHashMap<String, Metric> metricMap;
        Metric metric = this.metrics.remove(metricName);
        if (metric != null && (metricMap = this.getMetricMapByType(metric)) != null) {
            metricMap.remove(metricName);
        }
    }

    public void removeByPrefix(String prefix) {
        ArrayList<String> metricsToRemove = new ArrayList<String>();
        for (String name : this.metrics.keySet()) {
            if (!name.startsWith(prefix)) continue;
            metricsToRemove.add(name);
        }
        for (String name : metricsToRemove) {
            this.remove(name);
        }
    }

    public Map<String, Metric> getByPrefix(String prefix) {
        HashMap<String, Metric> metricsToReturn = new HashMap<String, Metric>();
        for (Map.Entry<String, Metric> entry : this.metrics.entrySet()) {
            String name = entry.getKey();
            if (!name.startsWith(prefix)) continue;
            metricsToReturn.put(name, entry.getValue());
        }
        return metricsToReturn;
    }
}

