/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.oshi.OshiChecker;
import com.gigaspaces.internal.oshi.OshiGaugeUtils;
import com.gigaspaces.internal.oshi.OshiUtils;
import com.gigaspaces.internal.sigar.SigarChecker;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.lrmi.ConnectionPool;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.nio.CPeer;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.metrics.DynamicMetricTag;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.InternalMetricRegistrator;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.metrics.MetricGroup;
import com.gigaspaces.metrics.MetricManagerConfig;
import com.gigaspaces.metrics.MetricPatternSet;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.metrics.MetricReporter;
import com.gigaspaces.metrics.MetricReporterFactory;
import com.gigaspaces.metrics.MetricSampler;
import com.gigaspaces.metrics.MetricSamplerConfig;
import com.gigaspaces.metrics.MetricTags;
import com.gigaspaces.metrics.factories.JvmMemoryMetricFactory;
import com.gigaspaces.metrics.factories.JvmRuntimeMetricFactory;
import com.gigaspaces.metrics.factories.JvmThreadMetricFactory;
import com.gigaspaces.metrics.factories.SigarCpuMetricFactory;
import com.gigaspaces.metrics.factories.SigarMemoryMetricFactory;
import com.gigaspaces.metrics.factories.SigarNetworkMetricFactory;
import com.gigaspaces.metrics.factories.SigarProcessMetricFactory;
import com.gigaspaces.metrics.factories.SigarSwapMetricFactory;
import com.gigaspaces.start.SystemBoot;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.kernel.threadpool.DynamicThreadPoolExecutor;
import com.sun.jini.thread.TaskManager;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class MetricManager
implements Closeable {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.metrics.manager");
    private static MetricManager instance;
    private static int refCount;
    private final Object lock = new Object();
    private final MetricTags defaultTags;
    private MetricPatternSet patternSet;
    private Map<String, MetricSampler> samplers;

    public static synchronized MetricManager acquire() {
        if (instance == null) {
            instance = new MetricManager();
        }
        ++refCount;
        return instance;
    }

    private static synchronized boolean release() {
        if (--refCount == 0) {
            instance = null;
            return true;
        }
        return false;
    }

    public static void reloadIfStarted() {
        MetricManager currInstance = instance;
        if (currInstance != null) {
            currInstance.reload();
        }
    }

    private MetricManager() {
        logger.log(Level.FINE, "Starting Metric Manager...");
        this.defaultTags = this.initDefaultTags();
        this.reload();
        logger.log(Level.FINE, "Started Metric Manager.");
        String processName = SystemBoot.getProcessRole();
        if (processName != null) {
            if (processName.equals("gsa")) {
                if (OshiChecker.isAvailable()) {
                    this.registerOperatingSystemMetricsWithOshi(this.createRegistrator("os"));
                } else {
                    this.registerOperatingSystemMetricsWithSigar(this.createRegistrator("os"));
                }
            }
            HashMap<String, String> processTags = new HashMap<String, String>();
            processTags.put("process_name", processName);
            this.registerProcessMetrics(processTags);
        }
    }

    public List<MetricRegistrator> registerProcessMetrics(Map<String, String> tags) {
        ArrayList<MetricRegistrator> registrators = new ArrayList<MetricRegistrator>();
        registrators.add(this.registerProcessMetricsInternal(tags));
        registrators.add(this.registerJvmMetrics(tags));
        registrators.add(this.registerLrmiMetrics(this.createRegistrator("lrmi", tags)));
        return registrators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        Object object = this.lock;
        synchronized (object) {
            if (this.samplers != null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Reloading Metrics Configuration");
                }
                for (MetricSampler sampler : this.samplers.values()) {
                    sampler.close();
                }
            }
            MetricManagerConfig config = MetricManagerConfig.loadFromXml(MetricManager.getConfigFilePath());
            this.patternSet = config.getPatternSet();
            HashMap<String, MetricSampler> newSamplers = new HashMap<String, MetricSampler>();
            for (MetricSamplerConfig samplerConfig : config.getSamplersConfig().values()) {
                ArrayList<MetricReporter> reporters = new ArrayList<MetricReporter>();
                for (Map.Entry<String, MetricReporterFactory> entry : config.getReportersFactories().entrySet()) {
                    reporters.add(this.createReporter(entry.getKey(), entry.getValue()));
                }
                newSamplers.put(samplerConfig.getName(), new MetricSampler(samplerConfig, reporters));
            }
            if (this.samplers != null) {
                for (MetricSampler sampler : this.samplers.values()) {
                    for (Map.Entry<MetricTags, MetricGroup> groupEntry : sampler.getRegistry().getGroups().entrySet()) {
                        for (Map.Entry<String, Metric> metricEntry : groupEntry.getValue().getMetrics().entrySet()) {
                            this.register(metricEntry.getKey(), groupEntry.getKey(), metricEntry.getValue(), newSamplers);
                        }
                    }
                }
            }
            this.samplers = newSamplers;
        }
    }

    public static String getConfigFilePath() {
        String result = System.getProperty("com.gigaspaces.metrics.config");
        if (!StringUtils.hasLength(result)) {
            result = SystemInfo.singleton().locations().config() + File.separator + "metrics" + File.separator + "metrics.xml";
        }
        return result;
    }

    private MetricTags initDefaultTags() {
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.put("host", SystemInfo.singleton().network().getHost().getHostName());
        tags.put("ip", SystemInfo.singleton().network().getHost().getHostAddress());
        tags.put("pid", String.valueOf(SystemInfo.singleton().os().processId()));
        return new MetricTags(tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!MetricManager.release()) {
            return;
        }
        logger.log(Level.FINE, "Closing Metric Manager...");
        Object object = this.lock;
        synchronized (object) {
            for (MetricSampler sampler : this.samplers.values()) {
                sampler.close();
            }
        }
        logger.log(Level.FINE, "Closed Metric Manager.");
    }

    public MetricRegistrator createRegistrator(String prefix) {
        return this.createRegistrator(prefix, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    public MetricRegistrator createRegistrator(String prefix, Map<String, String> tags) {
        return this.createRegistrator(prefix, tags, Collections.EMPTY_MAP);
    }

    public MetricRegistrator createRegistrator(String prefix, Map<String, String> tags, Map<String, DynamicMetricTag> dynamicTags) {
        return new InternalMetricRegistrator(this, prefix, this.defaultTags.extend(tags, dynamicTags));
    }

    public String getSeparator() {
        return this.patternSet.getSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(String metricName, MetricTags tags, Metric metric) {
        Object object = this.lock;
        synchronized (object) {
            this.register(metricName, tags, metric, this.samplers);
        }
    }

    private void register(String metricName, MetricTags tags, Metric metric, Map<String, MetricSampler> samplers) {
        String samplerName = this.patternSet.findBestMatch(metricName);
        samplers.get(samplerName).register(metricName, tags, metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(String metricName, MetricTags tags) {
        Object object = this.lock;
        synchronized (object) {
            for (MetricSampler sampler : this.samplers.values()) {
                sampler.remove(metricName, tags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterByPrefix(String prefix, MetricTags tags) {
        Object object = this.lock;
        synchronized (object) {
            for (MetricSampler sampler : this.samplers.values()) {
                sampler.removeByPrefix(prefix, tags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getSnapshotsByPrefix(Collection<String> prefixes) {
        Object object = this.lock;
        synchronized (object) {
            HashMap<String, Object> resultsMap = new HashMap<String, Object>();
            for (String prefix : prefixes) {
                for (MetricSampler sampler : this.samplers.values()) {
                    resultsMap.putAll(sampler.getSnapshotsByPrefix(prefix));
                }
            }
            return resultsMap;
        }
    }

    private MetricReporter createReporter(String name, MetricReporterFactory reporterFactory) {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Loading metric reporter factory " + name);
        }
        try {
            return reporterFactory.create();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create reporter " + name, e);
            return null;
        }
    }

    private void registerOperatingSystemMetricsWithSigar(MetricRegistrator registrator) {
        if (!SigarChecker.isAvailable()) {
            logger.info("Skipping operating system metrics registration - Sigar is not available");
            return;
        }
        SigarCpuMetricFactory cpuFactory = new SigarCpuMetricFactory();
        registrator.register(registrator.toPath("cpu", "used-percent"), cpuFactory.createUsedCpuInPercentGauge());
        SigarMemoryMetricFactory memoryFactory = new SigarMemoryMetricFactory();
        registrator.register(registrator.toPath("memory", "free-bytes"), memoryFactory.createFreeMemoryInBytesGauge());
        registrator.register(registrator.toPath("memory", "actual-free-bytes"), memoryFactory.createActualFreeMemoryInBytesGauge());
        registrator.register(registrator.toPath("memory", "used-bytes"), memoryFactory.createUsedMemoryInBytesGauge());
        registrator.register(registrator.toPath("memory", "actual-used-bytes"), memoryFactory.createActualUsedMemoryInBytesGauge());
        registrator.register(registrator.toPath("memory", "used-percent"), memoryFactory.createUsedMemoryInPercentGauge());
        SigarSwapMetricFactory swapFactory = new SigarSwapMetricFactory();
        registrator.register(registrator.toPath("swap", "free-bytes"), swapFactory.createFreeSwapInBytesGauge());
        registrator.register(registrator.toPath("swap", "used-bytes"), swapFactory.createUsedSwapInBytesGauge());
        registrator.register(registrator.toPath("swap", "used-percent"), swapFactory.createUsedSwapInPercentGauge());
        SigarNetworkMetricFactory networkFactory = new SigarNetworkMetricFactory();
        Collection<String> netInterfacesNames = MetricManager.getNetworkNames(networkFactory);
        for (String name : netInterfacesNames) {
            HashMap<String, String> newTags = new HashMap<String, String>();
            newTags.put("nic", name);
            MetricRegistrator networkRegistrator = ((InternalMetricRegistrator)registrator).extend("network", newTags, Collections.EMPTY_MAP);
            networkRegistrator.register("rx-bytes", networkFactory.createRxBytesGauge(name));
            networkRegistrator.register("tx-bytes", networkFactory.createTxBytesGauge(name));
            networkRegistrator.register("rx-packets", networkFactory.createRxPacketsGauge(name));
            networkRegistrator.register("tx-packets", networkFactory.createTxPacketsGauge(name));
            networkRegistrator.register("rx-errors", networkFactory.createRxErrorsGauge(name));
            networkRegistrator.register("tx-errors", networkFactory.createTxErrorsGauge(name));
            networkRegistrator.register("rx-dropped", networkFactory.createRxDroppedGauge(name));
            networkRegistrator.register("tx-dropped", networkFactory.createTxDroppedGauge(name));
        }
    }

    private static Collection<String> getNetworkNames(SigarNetworkMetricFactory factory) {
        try {
            return factory.getNetInterfacesNames();
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Failed to retrieve network interfaces names", e);
            return Collections.emptyList();
        }
    }

    private void registerOperatingSystemMetricsWithOshi(MetricRegistrator registrator) {
        OSStatistics.OSNetInterfaceStats[] netInterfaceStats;
        registrator.register(registrator.toPath("cpu", "used-percent"), OshiGaugeUtils.getCpuPercGauge());
        registrator.register(registrator.toPath("memory", "free-bytes"), OshiGaugeUtils.getFreeMemoryInBytesGauge());
        registrator.register(registrator.toPath("memory", "actual-free-bytes"), OshiGaugeUtils.getActualFreeMemoryInBytesGauge());
        registrator.register(registrator.toPath("memory", "used-bytes"), OshiGaugeUtils.getUsedMemoryInBytesGauge());
        registrator.register(registrator.toPath("memory", "actual-used-bytes"), OshiGaugeUtils.getActualUsedMemoryInBytesGauge());
        registrator.register(registrator.toPath("memory", "used-percent"), OshiGaugeUtils.getUsedMemoryInPercentGauge());
        registrator.register(registrator.toPath("swap", "free-bytes"), OshiGaugeUtils.getFreeSwapInBytesGauge());
        registrator.register(registrator.toPath("swap", "used-bytes"), OshiGaugeUtils.getUsedSwapInBytesGauge());
        registrator.register(registrator.toPath("swap", "used-percent"), OshiGaugeUtils.getUsedSwapInPercentGauge());
        for (OSStatistics.OSNetInterfaceStats interfaceStats : netInterfaceStats = OshiUtils.calcNetStats()) {
            HashMap<String, String> newTags = new HashMap<String, String>();
            newTags.put("nic", interfaceStats.getName());
            MetricRegistrator networkRegistrator = ((InternalMetricRegistrator)registrator).extend("network", newTags, Collections.EMPTY_MAP);
            networkRegistrator.register("rx-bytes", OshiGaugeUtils.createRxBytesGauge(interfaceStats));
            networkRegistrator.register("tx-bytes", OshiGaugeUtils.createTxBytesGauge(interfaceStats));
            networkRegistrator.register("rx-packets", OshiGaugeUtils.createRxPacketsGauge(interfaceStats));
            networkRegistrator.register("tx-packets", OshiGaugeUtils.createTxPacketsGauge(interfaceStats));
            networkRegistrator.register("rx-errors", OshiGaugeUtils.createRxErrorsGauge(interfaceStats));
            networkRegistrator.register("tx-errors", OshiGaugeUtils.createTxErrorsGauge(interfaceStats));
            networkRegistrator.register("rx-dropped", OshiGaugeUtils.createRxDroppedGauge(interfaceStats));
            networkRegistrator.register("tx-dropped", OshiGaugeUtils.createTxDroppedGauge(interfaceStats));
        }
    }

    private MetricRegistrator registerProcessMetricsInternal(Map<String, String> tags) {
        MetricRegistrator registrator = this.createRegistrator("process", tags);
        if (OshiChecker.isAvailable()) {
            registrator.register(registrator.toPath("cpu", "time-total"), OshiGaugeUtils.createProcessCpuTotalTimeGauge());
            registrator.register(registrator.toPath("cpu", "used-percent"), OshiGaugeUtils.createProcessUsedCpuInPercentGauge());
        } else if (!SigarChecker.isAvailable()) {
            logger.info("Skipping process metrics registration - Sigar is not available");
        } else {
            SigarProcessMetricFactory factory = new SigarProcessMetricFactory();
            registrator.register(registrator.toPath("cpu", "time-total"), factory.createProcessCpuTotalTimeGauge());
            registrator.register(registrator.toPath("cpu", "used-percent"), factory.createProcessUsedCpuInPercentGauge());
        }
        return registrator;
    }

    private MetricRegistrator registerJvmMetrics(Map<String, String> tags) {
        MetricRegistrator registrator = this.createRegistrator("jvm", tags);
        JvmRuntimeMetricFactory runtimeFactory = new JvmRuntimeMetricFactory();
        registrator.register("uptime", runtimeFactory.createUptimeGauge());
        JvmMemoryMetricFactory memoryFactory = new JvmMemoryMetricFactory();
        registrator.register(registrator.toPath("memory", "heap", "used-bytes"), memoryFactory.createHeapUsedInBytesGauge());
        registrator.register(registrator.toPath("memory", "heap", "committed-bytes"), memoryFactory.createHeapCommittedInBytesGauge());
        registrator.register(registrator.toPath("memory", "non-heap", "used-bytes"), memoryFactory.createNonHeapUsedInBytesGauge());
        registrator.register(registrator.toPath("memory", "non-heap", "committed-bytes"), memoryFactory.createNonHeapCommittedInBytesGauge());
        registrator.register(registrator.toPath("memory", "gc", "count"), memoryFactory.createCGCountGauge());
        registrator.register(registrator.toPath("memory", "gc", "time"), memoryFactory.createGCCollectionTimeGauge());
        JvmThreadMetricFactory threadFactory = new JvmThreadMetricFactory();
        registrator.register(registrator.toPath("threads", "count"), threadFactory.createThreadCountGauge());
        registrator.register(registrator.toPath("threads", "daemon"), threadFactory.createDaemonThreadCountGauge());
        registrator.register(registrator.toPath("threads", "peak"), threadFactory.createPeakThreadCountGauge());
        registrator.register(registrator.toPath("threads", "total-started"), threadFactory.createTotalStartedThreadCountGauge());
        return registrator;
    }

    private MetricRegistrator registerLrmiMetrics(MetricRegistrator registrator) {
        LRMIRuntime lrmiRuntime = LRMIRuntime.getRuntime();
        registrator.register("received-traffic", new LongCounter(Reader.getReceivedTrafficCounter()));
        registrator.register("generated-traffic", new LongCounter(Writer.getGeneratedTrafficCounter()));
        registrator.register("pending-writes", new LongCounter(Writer.getPendingWritesCounter()));
        registrator.register("connections", new LongCounter(CPeer.getConnectionsCounter()));
        registrator.register("active-connections", new LongCounter(ConnectionPool.getActiveConnectionsCounter()));
        MetricManager.registerThreadPoolMetrics(registrator.extend("connection-pool"), lrmiRuntime.getThreadPool());
        MetricManager.registerThreadPoolMetrics(registrator.extend("liveness-pool"), lrmiRuntime.getLivenessPriorityThreadPool());
        MetricManager.registerThreadPoolMetrics(registrator.extend("monitoring-pool"), lrmiRuntime.getMonitoringPriorityThreadPool());
        MetricManager.registerThreadPoolMetrics(registrator.extend("custom-pool"), lrmiRuntime.getCustomThreadPool());
        return registrator;
    }

    public static void registerThreadPoolMetrics(MetricRegistrator registrator, final DynamicThreadPoolExecutor dynamicThreadPoolExecutor) {
        registrator.register("active-threads", new Gauge<Integer>(){

            @Override
            public Integer getValue() throws Exception {
                return dynamicThreadPoolExecutor.getActiveCount();
            }
        });
        final BlockingQueue<Runnable> q = dynamicThreadPoolExecutor.getQueue();
        registrator.register("queueSize", new Gauge<Integer>(){

            @Override
            public Integer getValue() throws Exception {
                return q.size();
            }
        });
    }

    public static void registerTaskManagerMetrics(MetricRegistrator registrator, final TaskManager taskManager) {
        registrator.register("threads-count", new Gauge<Integer>(){

            @Override
            public Integer getValue() throws Exception {
                return taskManager.getThreadCount();
            }
        });
        registrator.register("total-tasks", new Gauge<Integer>(){

            @Override
            public Integer getValue() throws Exception {
                return taskManager.getTotalTasks();
            }
        });
    }
}

