/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.xml.XmlParser;
import com.gigaspaces.metrics.MetricPatternSet;
import com.gigaspaces.metrics.MetricReporterFactory;
import com.gigaspaces.metrics.MetricSamplerConfig;
import com.gigaspaces.metrics.reporters.ConsoleReporterFactory;
import com.gigaspaces.metrics.reporters.FileReporterFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@InternalApi
public class MetricManagerConfig {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.metrics.manager");
    private final String separator;
    private final MetricPatternSet patterns;
    private final Map<String, MetricReporterFactory> reportersFactories;
    private final Map<String, MetricSamplerConfig> samplers;

    public MetricManagerConfig() {
        this.separator = "_";
        this.patterns = new MetricPatternSet(this.separator);
        this.reportersFactories = new HashMap<String, MetricReporterFactory>();
        this.samplers = new HashMap<String, MetricSamplerConfig>();
        this.samplers.put("off", new MetricSamplerConfig("off", 0L, null));
        this.samplers.put("default", new MetricSamplerConfig("default", MetricSamplerConfig.DEFAULT_SAMPLING_RATE, null));
    }

    public void loadXml(String path) {
        XmlParser xmlParser = XmlParser.fromPath(path);
        NodeList reporterNodes = xmlParser.getNodes("/metrics-configuration/reporters/reporter");
        for (int i = 0; i < reporterNodes.getLength(); ++i) {
            this.parseReporter((Element)reporterNodes.item(i));
        }
        NodeList samplerNodes = xmlParser.getNodes("/metrics-configuration/samplers/sampler");
        for (int i = 0; i < samplerNodes.getLength(); ++i) {
            this.parseSampler((Element)samplerNodes.item(i));
        }
        NodeList metricNodes = xmlParser.getNodes("/metrics-configuration/metrics/metric");
        for (int i = 0; i < metricNodes.getLength(); ++i) {
            this.parseMetric((Element)metricNodes.item(i));
        }
    }

    public static MetricManagerConfig loadFromXml(String fileName) {
        MetricManagerConfig config = new MetricManagerConfig();
        File file = new File(fileName);
        if (file.exists()) {
            if (file.canRead()) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "Loading metrics configuration from " + file.getAbsolutePath());
                }
                config.loadXml(fileName);
            } else if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Unable to read metrics configuration from " + file.getAbsolutePath());
            }
        } else if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Metrics configuration file " + file.getAbsolutePath() + " does not exist");
        }
        return config;
    }

    private void parseReporter(Element element) {
        MetricReporterFactory factory;
        String name = element.getAttribute("name");
        String factoryClassName = element.getAttribute("factory-class");
        if (StringUtils.hasLength(factoryClassName)) {
            factory = MetricManagerConfig.fromName(factoryClassName);
        } else if (name.equals("influxdb")) {
            factory = MetricManagerConfig.fromName("com.gigaspaces.metrics.influxdb.InfluxDBReporterFactory");
        } else if (name.equals("console")) {
            factory = new ConsoleReporterFactory();
        } else if (name.equals("file")) {
            factory = new FileReporterFactory();
        } else {
            throw new IllegalArgumentException("Failed to create factory '" + name + "' without a custom class");
        }
        factory.setPathSeparator(this.separator);
        factory.load(XmlParser.parseProperties(element, "name", "value"));
        this.reportersFactories.put(name, factory);
    }

    private static MetricReporterFactory fromName(String factoryClassName) {
        try {
            Class<?> factoryClass = Class.forName(factoryClassName);
            return (MetricReporterFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to create MetricReporterFactory", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to create MetricReporterFactory", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to create MetricReporterFactory", e);
        }
    }

    private void parseSampler(Element element) {
        String levelName = element.getAttribute("name");
        Long sampleRate = StringUtils.parseDurationAsMillis(element.getAttribute("sample-rate"));
        Long reportRate = StringUtils.parseDurationAsMillis(element.getAttribute("report-rate"));
        this.samplers.put(levelName, new MetricSamplerConfig(levelName, sampleRate, reportRate));
    }

    private void parseMetric(Element element) {
        String prefix = element.getAttribute("prefix");
        String sampler = element.getAttribute("sampler");
        this.patterns.add(prefix, sampler);
    }

    public String getSeparator() {
        return this.separator;
    }

    public Map<String, MetricReporterFactory> getReportersFactories() {
        return this.reportersFactories;
    }

    public Map<String, MetricSamplerConfig> getSamplersConfig() {
        return this.samplers;
    }

    public MetricPatternSet getPatternSet() {
        return this.patterns;
    }
}

