/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metrics.MetricPatternSet;

@InternalApi
public class MetricPattern {
    private final String pattern;
    private final String value;
    private final String[] tokens;
    private final int jokers;

    public MetricPattern(String pattern, String value, MetricPatternSet owner) {
        this.pattern = pattern;
        this.value = value;
        this.tokens = owner.split(pattern);
        this.jokers = this.countJokers(this.tokens);
    }

    private final int countJokers(String[] tokens) {
        int result = 0;
        for (String token : tokens) {
            if (!token.equals("*")) continue;
            ++result;
        }
        return result;
    }

    public boolean match(MetricPattern other) {
        if (this.pattern.equals(other.pattern)) {
            return true;
        }
        if (other.tokens.length > this.tokens.length) {
            return false;
        }
        int length = other.tokens.length;
        for (int i = 0; i < length; ++i) {
            if (other.tokens[i].equals("*") || other.tokens[i].equals(this.tokens[i])) continue;
            return false;
        }
        return true;
    }

    public int getTokens() {
        return this.tokens.length;
    }

    public int getJokers() {
        return this.jokers;
    }

    public String getValue() {
        return this.value;
    }
}

