/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metrics.MetricPattern;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class MetricPatternSet {
    private final String separator;
    private final List<MetricPattern> patterns;

    public MetricPatternSet(String separator) {
        this.separator = separator;
        this.patterns = new ArrayList<MetricPattern>();
    }

    public String getSeparator() {
        return this.separator;
    }

    public void add(String pattern, String sampler) {
        this.patterns.add(new MetricPattern(pattern, sampler, this));
    }

    public String findBestMatch(String s) {
        MetricPattern p1 = new MetricPattern(s, null, this);
        MetricPattern result = null;
        for (MetricPattern pattern : this.patterns) {
            if (!p1.match(pattern)) continue;
            result = MetricPatternSet.bestMatch(result, pattern);
        }
        return result != null ? result.getValue() : "default";
    }

    String[] split(String pattern) {
        return StringUtils.tokenizeToStringArray(pattern, this.separator);
    }

    private static MetricPattern bestMatch(MetricPattern currPattern, MetricPattern newPattern) {
        if (currPattern == null) {
            return newPattern;
        }
        if (currPattern.getTokens() < newPattern.getTokens()) {
            return newPattern;
        }
        if (currPattern.getJokers() > newPattern.getJokers()) {
            return newPattern;
        }
        return currPattern;
    }
}

