/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.metrics.MetricGroup;
import com.gigaspaces.metrics.MetricGroupSnapshot;
import com.gigaspaces.metrics.MetricRegistrySnapshot;
import com.gigaspaces.metrics.MetricTags;
import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.ThroughputMetric;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetricRegistry {
    private final String name;
    private final Logger logger;
    private final Map<MetricTags, MetricGroup> groups;

    public MetricRegistry(String name) {
        this.name = name;
        this.logger = Logger.getLogger("com.gigaspaces.metrics.registry." + name);
        this.groups = new ConcurrentHashMap<MetricTags, MetricGroup>();
    }

    public String getName() {
        return this.name;
    }

    public Map<MetricTags, MetricGroup> getGroups() {
        return this.groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, MetricTags tags, Metric metric) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Registering " + name + "[tags=" + tags.getTags() + "]");
        }
        if (!this.verifyMetric(name, metric)) {
            return;
        }
        Map<MetricTags, MetricGroup> map = this.groups;
        synchronized (map) {
            MetricGroup group = this.groups.get(tags);
            if (group == null) {
                group = new MetricGroup();
                this.groups.put(tags, group);
            }
            group.register(name, metric);
        }
    }

    private boolean verifyMetric(String name, Metric metric) {
        try {
            if (metric instanceof Gauge) {
                Gauge gauge = (Gauge)metric;
                Object value = gauge.getValue();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Verified gauge " + name + " => " + value);
                }
            } else if (!(metric instanceof LongCounter) && !(metric instanceof ThroughputMetric)) {
                throw new IllegalArgumentException("Unsupported metric type: " + metric.getClass().getName());
            }
            return true;
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Registration of metric '" + name + "' was skipped because its value cannot be retrieved - " + e.getMessage(), e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String metricName, MetricTags tags) {
        Map<MetricTags, MetricGroup> map = this.groups;
        synchronized (map) {
            MetricGroup group = this.groups.get(tags);
            if (group != null) {
                group.remove(metricName);
                if (group.isEmpty()) {
                    this.groups.remove(tags);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByPrefix(String prefix, MetricTags tags) {
        Map<MetricTags, MetricGroup> map = this.groups;
        synchronized (map) {
            MetricGroup group = this.groups.get(tags);
            if (group != null) {
                group.removeByPrefix(prefix);
                if (group.isEmpty()) {
                    this.groups.remove(tags);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getSnapshotsByPrefix(String prefix) {
        Map<MetricTags, MetricGroup> map = this.groups;
        synchronized (map) {
            HashMap<String, Object> metricsSnapshot = new HashMap<String, Object>();
            for (MetricGroup group : this.groups.values()) {
                if (group == null) continue;
                Map<String, Metric> metricsFilteredByPrefix = group.getByPrefix(prefix);
                Set<Map.Entry<String, Metric>> entries = metricsFilteredByPrefix.entrySet();
                for (Map.Entry<String, Metric> entry : entries) {
                    try {
                        metricsSnapshot.put(entry.getKey(), this.getMetricSnapshot(entry.getValue()));
                    }
                    catch (Exception e) {
                        if (!this.logger.isLoggable(Level.FINE)) continue;
                        this.logger.log(Level.FINE, e.toString(), e);
                    }
                }
            }
            return metricsSnapshot;
        }
    }

    private Object getMetricSnapshot(Metric metric) throws Exception {
        Long resultVal = null;
        if (metric instanceof Gauge) {
            resultVal = (Long)((Gauge)metric).getValue();
        } else if (metric instanceof LongCounter) {
            resultVal = ((LongCounter)metric).getCount();
        } else if (metric instanceof ThroughputMetric) {
            resultVal = ((ThroughputMetric)metric).getTotal();
        }
        return resultVal;
    }

    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    public MetricRegistrySnapshot snapshot(long timestamp) {
        HashMap<MetricTagsSnapshot, MetricGroupSnapshot> groupsSnapshots = new HashMap<MetricTagsSnapshot, MetricGroupSnapshot>(this.groups.size());
        for (Map.Entry<MetricTags, MetricGroup> groupEntry : this.groups.entrySet()) {
            groupsSnapshots.put(groupEntry.getKey().snapshot(), groupEntry.getValue().snapshot());
        }
        return new MetricRegistrySnapshot(timestamp, groupsSnapshots);
    }
}

