/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.metrics.MetricGroupSnapshot;
import com.gigaspaces.metrics.MetricRegistrySnapshot;
import com.gigaspaces.metrics.MetricReporterFactory;
import com.gigaspaces.metrics.MetricTagsSnapshot;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class MetricReporter
implements Closeable {
    private final Map<MetricTagsSnapshot, Map<String, String>> metricsNamesCache = new ConcurrentHashMap<MetricTagsSnapshot, Map<String, String>>();

    protected MetricReporter(MetricReporterFactory factory) {
    }

    public void report(List<MetricRegistrySnapshot> snapshots) {
        for (MetricRegistrySnapshot snapshot : snapshots) {
            this.report(snapshot);
        }
    }

    protected void report(MetricRegistrySnapshot snapshot) {
        for (Map.Entry<MetricTagsSnapshot, MetricGroupSnapshot> entry : snapshot.getGroups().entrySet()) {
            this.report(snapshot, entry.getKey(), entry.getValue());
        }
    }

    protected void report(MetricRegistrySnapshot snapshot, MetricTagsSnapshot tags, MetricGroupSnapshot group) {
        for (Map.Entry<String, Object> entry : group.getMetricsValues().entrySet()) {
            this.report(snapshot, tags, this.getMetricNameForReport(entry.getKey(), tags), entry.getValue());
        }
    }

    protected void report(MetricRegistrySnapshot snapshot, MetricTagsSnapshot tags, String key, Object value) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public void close() {
    }

    public String getMetricNameForReport(String metricName, MetricTagsSnapshot tags) {
        String result;
        Map<String, String> taggedCache = this.metricsNamesCache.get(tags);
        if (taggedCache == null) {
            taggedCache = new ConcurrentHashMap<String, String>();
            this.metricsNamesCache.put(tags, taggedCache);
        }
        if ((result = taggedCache.get(metricName)) == null) {
            result = this.toReportMetricName(metricName, tags);
            taggedCache.put(metricName, result);
        }
        return result;
    }

    protected String toReportMetricName(String metricName, MetricTagsSnapshot tags) {
        return metricName;
    }
}

