/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.metrics.MetricRegistry;
import com.gigaspaces.metrics.MetricRegistrySnapshot;
import com.gigaspaces.metrics.MetricReporter;
import com.gigaspaces.metrics.MetricSamplerConfig;
import com.gigaspaces.metrics.MetricTags;
import com.gigaspaces.metrics.internal.GaugeContextProvider;
import com.gigaspaces.metrics.internal.InternalGauge;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class MetricSampler
implements Closeable {
    private final Object lock = new Object();
    private final Logger logger;
    private final MetricRegistry registry;
    private final Set<GaugeContextProvider> contextProviders;
    private final ScheduledExecutorService executor;
    private final long samplingRate;
    private final int batchSize;
    private final Collection<MetricReporter> reporters;
    private final String name;
    private ScheduledFuture<?> future;

    public MetricSampler(MetricSamplerConfig config, Collection<MetricReporter> reporters) {
        this.name = config.getName();
        this.logger = Logger.getLogger("com.gigaspaces.metrics.sampler." + this.name);
        this.registry = new MetricRegistry(this.name);
        this.contextProviders = Collections.newSetFromMap(new ConcurrentHashMap());
        this.samplingRate = config.getSamplingRate();
        this.batchSize = config.getBatchSize();
        this.reporters = reporters;
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new GSThreadFactory("metrics-sampler-" + config.getName(), true));
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.log(Level.CONFIG, "Metric sampler created [sampleRate=" + this.samplingRate + "ms, batchSize=" + this.batchSize + "]");
        }
    }

    private boolean shouldBeActive() {
        return !this.reporters.isEmpty() && !this.registry.isEmpty() && this.samplingRate > 0L;
    }

    public boolean isActive() {
        return this.future != null;
    }

    @Override
    public void close() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Closing metric sampler");
        }
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.logger.warning("ScheduledExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        for (MetricReporter reporter : this.reporters) {
            reporter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, MetricTags tags, Metric metric) {
        GaugeContextProvider contextProvider;
        this.registry.register(name, tags, metric);
        if (metric instanceof InternalGauge && (contextProvider = ((InternalGauge)metric).getContextProvider()) != null) {
            this.contextProviders.add(contextProvider);
        }
        if (!this.isActive() && this.shouldBeActive()) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isActive() && this.shouldBeActive()) {
                    this.future = this.executor.scheduleAtFixedRate(new Sampler(), 0L, this.samplingRate, TimeUnit.MILLISECONDS);
                    if (this.logger.isLoggable(Level.CONFIG)) {
                        this.logger.log(Level.CONFIG, "Started metric sampler [sample-rate=" + this.samplingRate + "ms]");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String metricName, MetricTags tags) {
        this.registry.remove(metricName, tags);
        if (this.isActive() && !this.shouldBeActive()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isActive() && !this.shouldBeActive()) {
                    this.future.cancel(true);
                    this.future = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByPrefix(String prefix, MetricTags tags) {
        this.registry.removeByPrefix(prefix, tags);
        if (this.isActive() && !this.shouldBeActive()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isActive() && !this.shouldBeActive()) {
                    this.future.cancel(true);
                    this.future = null;
                }
            }
        }
    }

    public Map<String, Object> getSnapshotsByPrefix(String prefix) {
        return this.registry.getSnapshotsByPrefix(prefix);
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public String toString() {
        return "MetricSampler{name='" + this.name + '\'' + '}';
    }

    private class Sampler
    implements Runnable {
        private final List<MetricRegistrySnapshot> buffer;

        private Sampler() {
            this.buffer = new ArrayList<MetricRegistrySnapshot>(MetricSampler.this.batchSize);
        }

        @Override
        public void run() {
            long duration;
            if (MetricSampler.this.logger.isLoggable(Level.FINEST)) {
                MetricSampler.this.logger.log(Level.FINEST, "Sample started");
            }
            for (GaugeContextProvider contextProvider : MetricSampler.this.contextProviders) {
                contextProvider.reset();
            }
            long sampleTime = System.currentTimeMillis();
            MetricRegistrySnapshot snapshot = MetricSampler.this.registry.snapshot(sampleTime);
            if (MetricSampler.this.logger.isLoggable(Level.FINEST)) {
                duration = System.currentTimeMillis() - sampleTime;
                MetricSampler.this.logger.log(Level.FINEST, "Snapshot completed [sampleTime=" + sampleTime + ", duration=" + duration + "ms, groups=" + snapshot.getGroups().size() + ", metrics=" + snapshot.getTotalMetrics() + "]");
            }
            this.buffer.add(snapshot);
            if (this.buffer.size() == MetricSampler.this.batchSize) {
                for (MetricReporter reporter : MetricSampler.this.reporters) {
                    long startTime = 0L;
                    if (MetricSampler.this.logger.isLoggable(Level.FINEST)) {
                        startTime = System.currentTimeMillis();
                        MetricSampler.this.logger.log(Level.FINEST, "Starting buffer report via " + reporter.toString());
                    }
                    reporter.report(this.buffer);
                    if (!MetricSampler.this.logger.isLoggable(Level.FINEST)) continue;
                    long duration2 = System.currentTimeMillis() - startTime;
                    MetricSampler.this.logger.log(Level.FINEST, "Finished buffer report via " + reporter.toString() + "[duration=" + duration2 + "ms]");
                }
                this.buffer.clear();
            }
            if (MetricSampler.this.logger.isLoggable(Level.FINEST)) {
                duration = System.currentTimeMillis() - sampleTime;
                MetricSampler.this.logger.log(Level.FINEST, "Sample completed [duration=" + duration + "ms]");
            }
        }
    }
}

