/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

@InternalApi
public class MetricSamplerConfig {
    private static final Logger logger = Logger.getLogger(MetricSamplerConfig.class.getName());
    static final long DEFAULT_SAMPLING_RATE = TimeUnit.SECONDS.toMillis(5L);
    private final String name;
    private final long sampleRate;
    private final long reportRate;
    private final int batchSize;

    public MetricSamplerConfig(String name, Long sampleRate, Long reportRate) {
        this.name = name.toLowerCase();
        if (sampleRate == null) {
            throw new IllegalArgumentException("sampleRate cannot be null");
        }
        this.sampleRate = sampleRate;
        this.reportRate = this.initReportRate(reportRate);
        this.batchSize = this.reportRate == this.sampleRate ? 1 : (int)(this.reportRate / this.sampleRate);
    }

    private long initReportRate(Long reportRate) {
        long reportRateValue;
        long l = reportRateValue = reportRate != null ? reportRate : this.sampleRate;
        if (reportRateValue < this.sampleRate) {
            logger.warning("reportRate (" + reportRate + ") cannot be less than sampleRate (" + this.sampleRate + ") - setting reportRate to sampleRate");
            return this.sampleRate;
        }
        if (reportRateValue != this.sampleRate && reportRateValue % this.sampleRate != 0L) {
            int batchSize = (int)Math.ceil((double)reportRateValue / (double)this.sampleRate);
            reportRateValue = (long)batchSize * this.sampleRate;
            logger.warning("reportRate was increased from " + reportRate + " to " + reportRateValue + " - must be a multiple of sampleRate (" + this.sampleRate + ")");
        }
        return reportRateValue;
    }

    public String getName() {
        return this.name;
    }

    public long getSamplingRate() {
        return this.sampleRate;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

