/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metrics.DynamicMetricTag;
import com.gigaspaces.metrics.MetricTagsSnapshot;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class MetricTags {
    private final Map<String, Object> tags;
    private final Map<String, DynamicMetricTag> dynamicTags;
    private final String id;
    private Map<String, Object> tagsSnapshot;
    private MetricTagsSnapshot snapshot;

    public MetricTags(Map<String, Object> tags) {
        this(tags, Collections.EMPTY_MAP);
    }

    public MetricTags(Map<String, Object> tags, Map<String, DynamicMetricTag> dynamicTags) {
        this.tags = Collections.unmodifiableMap(tags);
        this.dynamicTags = dynamicTags;
        this.id = tags.toString() + (dynamicTags.isEmpty() ? "" : "_" + dynamicTags.keySet().toString());
        if (dynamicTags.isEmpty()) {
            this.tagsSnapshot = tags;
        } else {
            this.tagsSnapshot = new HashMap<String, Object>(tags);
            for (Map.Entry<String, DynamicMetricTag> entry : dynamicTags.entrySet()) {
                this.tagsSnapshot.put(entry.getKey(), entry.getValue().getValue());
            }
        }
        this.snapshot = new MetricTagsSnapshot(this.tagsSnapshot);
    }

    public MetricTags extend(Map<String, String> newTags, Map<String, DynamicMetricTag> newDynamicTags) {
        if (newTags.isEmpty() && newDynamicTags.isEmpty()) {
            return this;
        }
        HashMap<String, Object> mergedTags = new HashMap<String, Object>(this.tags);
        mergedTags.putAll(newTags);
        HashMap<String, DynamicMetricTag> mergedDynamicTags = Collections.EMPTY_MAP;
        if (!this.dynamicTags.isEmpty()) {
            mergedDynamicTags = new HashMap<String, DynamicMetricTag>(this.dynamicTags);
        }
        if (newDynamicTags != null && !newDynamicTags.isEmpty()) {
            if (mergedDynamicTags.isEmpty()) {
                mergedDynamicTags = new HashMap<String, DynamicMetricTag>(newDynamicTags);
            } else {
                mergedDynamicTags.putAll(newDynamicTags);
            }
        }
        return new MetricTags(mergedTags, mergedDynamicTags);
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetricTags)) {
            return false;
        }
        MetricTags other = (MetricTags)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public MetricTagsSnapshot snapshot() {
        if (!this.dynamicTags.isEmpty()) {
            boolean hasChanges = false;
            for (Map.Entry<String, DynamicMetricTag> entry : this.dynamicTags.entrySet()) {
                String tag = entry.getKey();
                Object currValue = entry.getValue().getValue();
                Object prevValue = this.tagsSnapshot.get(tag);
                if (prevValue.equals(currValue)) continue;
                hasChanges = true;
                this.tagsSnapshot.put(tag, currValue);
            }
            if (hasChanges) {
                this.snapshot = new MetricTagsSnapshot(this.tagsSnapshot);
            }
        }
        return this.snapshot;
    }
}

