/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.Metric;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ThroughputMetric
extends Metric {
    private static final double NANOSEC_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final Logger logger = Logger.getLogger("com.gigaspaces.metrics.manager");
    private final LongCounter total = new LongCounter();
    private long prevTotal;
    private long prevTime = System.nanoTime();

    public void increment() {
        this.add(1L);
    }

    public void add(long n) {
        this.total.inc(n);
    }

    public long getTotal() {
        return this.total.getCount();
    }

    public double sampleThroughput() {
        long total = this.getTotal();
        long delta = total - this.prevTotal;
        this.prevTotal = total;
        long currTime = System.nanoTime();
        long elapsedTime = currTime - this.prevTime;
        this.prevTime = currTime;
        double result = (double)delta / ((double)elapsedTime / NANOSEC_PER_SECOND);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "delta=" + delta + ", period=" + (double)elapsedTime / NANOSEC_PER_SECOND + "s, TP=" + result);
        }
        return result;
    }

    public Metric getTotalMetric() {
        return this.total;
    }
}

