/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.factories;

import com.gigaspaces.metrics.Gauge;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.List;

public class JvmMemoryMetricFactory {
    private final MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();

    public Gauge<Long> createHeapUsedInBytesGauge() {
        return new Gauge<Long>(){

            @Override
            public Long getValue() {
                return JvmMemoryMetricFactory.this.mxBean.getHeapMemoryUsage().getUsed();
            }
        };
    }

    public Gauge<Long> createHeapCommittedInBytesGauge() {
        return new Gauge<Long>(){

            @Override
            public Long getValue() {
                return JvmMemoryMetricFactory.this.mxBean.getHeapMemoryUsage().getCommitted();
            }
        };
    }

    public Gauge<Long> createNonHeapUsedInBytesGauge() {
        return new Gauge<Long>(){

            @Override
            public Long getValue() {
                return JvmMemoryMetricFactory.this.mxBean.getNonHeapMemoryUsage().getUsed();
            }
        };
    }

    public Gauge<Long> createNonHeapCommittedInBytesGauge() {
        return new Gauge<Long>(){

            @Override
            public Long getValue() {
                return JvmMemoryMetricFactory.this.mxBean.getNonHeapMemoryUsage().getCommitted();
            }
        };
    }

    public Gauge<Long> createCGCountGauge() {
        return new Gauge<Long>(){

            @Override
            public Long getValue() {
                long gcCollectionCount = 0L;
                List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
                for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
                    long tmp = gcMxBean.getCollectionCount();
                    if (tmp == -1L) continue;
                    gcCollectionCount += tmp;
                }
                return gcCollectionCount;
            }
        };
    }

    public Gauge<Long> createGCCollectionTimeGauge() {
        return new Gauge<Long>(){

            @Override
            public Long getValue() {
                long gcCollectionTime = 0L;
                List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
                for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
                    long tmp = gcMxBean.getCollectionTime();
                    if (tmp == -1L) continue;
                    gcCollectionTime += tmp;
                }
                return gcCollectionTime;
            }
        };
    }
}

