/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.factories;

import com.gigaspaces.internal.sigar.SigarHolder;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.internal.GaugeContextProvider;
import com.gigaspaces.metrics.internal.InternalGauge;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarCpuMetricFactory {
    private final SigarCpuWrapper context = new SigarCpuWrapper();

    public Gauge<Double> createUsedCpuInPercentGauge() {
        return new InternalGauge<Double>((GaugeContextProvider)this.context){

            @Override
            public Double getValue() throws SigarException {
                return 1.validate(((CpuPerc)SigarCpuMetricFactory.this.context.get()).getCombined());
            }
        };
    }

    private static class SigarCpuWrapper
    extends GaugeContextProvider<CpuPerc> {
        private final Sigar sigar = SigarHolder.getSigar();

        private SigarCpuWrapper() {
        }

        @Override
        protected CpuPerc loadValue() {
            try {
                return this.sigar.getCpuPerc();
            }
            catch (SigarException e) {
                throw new RuntimeException("Failed to get cpu info from sigar", e);
            }
        }
    }
}

