/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.factories;

import com.gigaspaces.internal.sigar.SigarHolder;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.internal.GaugeContextProvider;
import com.gigaspaces.metrics.internal.InternalGauge;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarMemoryMetricFactory {
    private final SigarMemWrapper context = new SigarMemWrapper();
    private final boolean _isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");

    public Gauge<Long> createFreeMemoryInBytesGauge() {
        return new InternalGauge<Long>((GaugeContextProvider)this.context){

            @Override
            public Long getValue() throws SigarException {
                return ((Mem)SigarMemoryMetricFactory.this.context.get()).getFree();
            }
        };
    }

    public Gauge<Long> createActualFreeMemoryInBytesGauge() {
        return new InternalGauge<Long>((GaugeContextProvider)this.context){

            @Override
            public Long getValue() throws SigarException {
                return ((Mem)SigarMemoryMetricFactory.this.context.get()).getActualFree();
            }
        };
    }

    public Gauge<Long> createUsedMemoryInBytesGauge() {
        return new InternalGauge<Long>((GaugeContextProvider)this.context){

            @Override
            public Long getValue() throws SigarException {
                return ((Mem)SigarMemoryMetricFactory.this.context.get()).getUsed();
            }
        };
    }

    public Gauge<Long> createActualUsedMemoryInBytesGauge() {
        if (this._isWindows) {
            return new InternalGauge<Long>((GaugeContextProvider)this.context){

                @Override
                public Long getValue() throws SigarException {
                    Mem mem = (Mem)SigarMemoryMetricFactory.this.context.get();
                    return mem.getTotal() - mem.getFree();
                }
            };
        }
        return new InternalGauge<Long>((GaugeContextProvider)this.context){

            @Override
            public Long getValue() throws SigarException {
                return ((Mem)SigarMemoryMetricFactory.this.context.get()).getActualUsed();
            }
        };
    }

    public Gauge<Double> createUsedMemoryInPercentGauge() {
        if (this._isWindows) {
            return new InternalGauge<Double>((GaugeContextProvider)this.context){

                @Override
                public Double getValue() throws SigarException {
                    Mem mem = (Mem)SigarMemoryMetricFactory.this.context.get();
                    return this.calculatePercent(mem.getTotal() - mem.getFree(), mem.getTotal());
                }
            };
        }
        return new InternalGauge<Double>((GaugeContextProvider)this.context){

            @Override
            public Double getValue() throws SigarException {
                return 7.validate(((Mem)SigarMemoryMetricFactory.this.context.get()).getUsedPercent());
            }
        };
    }

    private static class SigarMemWrapper
    extends GaugeContextProvider<Mem> {
        private final Sigar sigar = SigarHolder.getSigar();

        private SigarMemWrapper() {
        }

        @Override
        protected Mem loadValue() {
            try {
                return this.sigar.getMem();
            }
            catch (SigarException e) {
                throw new RuntimeException("Failed to get memory info from sigar", e);
            }
        }
    }
}

