/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.factories;

import com.gigaspaces.internal.sigar.SigarHolder;
import com.gigaspaces.metrics.Gauge;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarNetworkMetricFactory {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.metrics.manager");
    private final Sigar sigar = SigarHolder.getSigar();

    public Collection<String> getNetInterfacesNames() {
        try {
            HashSet<String> result = new HashSet<String>();
            Object[] names = this.sigar.getNetInterfaceList();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The following network interface cards were detected by Sigar: " + Arrays.toString(names));
            }
            for (Object name : names) {
                NetInterfaceConfig config = this.sigar.getNetInterfaceConfig((String)name);
                if (config.getAddress().equals("0.0.0.0")) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Skipping " + SigarNetworkMetricFactory.nameWithAddress((String)name, config) + " - invalid address");
                    continue;
                }
                boolean added = result.add((String)name);
                if (added) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, SigarNetworkMetricFactory.nameWithAddress((String)name, config) + " will be registered for metrics");
                    continue;
                }
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Skipping " + SigarNetworkMetricFactory.nameWithAddress((String)name, config) + " - a NIC by the same name has already been registered for metrics");
            }
            return result;
        }
        catch (SigarException e) {
            throw new RuntimeException("Failed to get network interfaces names", e);
        }
    }

    private static String nameWithAddress(String name, NetInterfaceConfig config) {
        return "NIC [" + name + "] with address [" + config.getAddress() + "]";
    }

    public Gauge<Long> createRxBytesGauge(final String interfaceName) {
        return new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return SigarNetworkMetricFactory.this.sigar.getNetInterfaceStat(interfaceName).getRxBytes();
            }
        };
    }

    public Gauge<Long> createTxBytesGauge(final String interfaceName) {
        return new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return SigarNetworkMetricFactory.this.sigar.getNetInterfaceStat(interfaceName).getTxBytes();
            }
        };
    }

    public Gauge<Long> createRxPacketsGauge(final String interfaceName) {
        return new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return SigarNetworkMetricFactory.this.sigar.getNetInterfaceStat(interfaceName).getRxPackets();
            }
        };
    }

    public Gauge<Long> createTxPacketsGauge(final String interfaceName) {
        return new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return SigarNetworkMetricFactory.this.sigar.getNetInterfaceStat(interfaceName).getTxPackets();
            }
        };
    }

    public Gauge<Long> createRxErrorsGauge(final String interfaceName) {
        return new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return SigarNetworkMetricFactory.this.sigar.getNetInterfaceStat(interfaceName).getRxErrors();
            }
        };
    }

    public Gauge<Long> createTxErrorsGauge(final String interfaceName) {
        return new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return SigarNetworkMetricFactory.this.sigar.getNetInterfaceStat(interfaceName).getTxErrors();
            }
        };
    }

    public Gauge<Long> createRxDroppedGauge(final String interfaceName) {
        return new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return SigarNetworkMetricFactory.this.sigar.getNetInterfaceStat(interfaceName).getRxDropped();
            }
        };
    }

    public Gauge<Long> createTxDroppedGauge(final String interfaceName) {
        return new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return SigarNetworkMetricFactory.this.sigar.getNetInterfaceStat(interfaceName).getTxDropped();
            }
        };
    }
}

