/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.factories;

import com.gigaspaces.internal.sigar.SigarHolder;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.internal.GaugeContextProvider;
import com.gigaspaces.metrics.internal.InternalGauge;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarProcessMetricFactory {
    private static final int processors = Runtime.getRuntime().availableProcessors();
    private final SigarProcessCpuWrapper context = new SigarProcessCpuWrapper();

    public void reset() {
        this.context.reset();
    }

    public Gauge<Long> createProcessCpuTotalTimeGauge() {
        return new InternalGauge<Long>((GaugeContextProvider)this.context){

            @Override
            public Long getValue() {
                return ((ProcCpu)SigarProcessMetricFactory.this.context.get()).getTotal();
            }
        };
    }

    public Gauge<Double> createProcessUsedCpuInPercentGauge() {
        return new InternalGauge<Double>((GaugeContextProvider)this.context){

            @Override
            public Double getValue() {
                return 2.validate(((ProcCpu)SigarProcessMetricFactory.this.context.get()).getPercent() * 100.0 / (double)processors);
            }
        };
    }

    public Gauge<Double> createProcessCpuLoadGauge() {
        return new InternalGauge<Double>((GaugeContextProvider)this.context){
            private long prevTotal;
            private long prevTime;
            {
                this.prevTotal = ((ProcCpu)SigarProcessMetricFactory.this.context.get()).getTotal();
                this.prevTime = ((ProcCpu)SigarProcessMetricFactory.this.context.get()).getStartTime();
            }

            @Override
            public Double getValue() {
                ProcCpu procCpu = (ProcCpu)SigarProcessMetricFactory.this.context.get();
                double cpuTime = procCpu.getTotal() - this.prevTotal;
                long elapsedTime = procCpu.getLastTime() - this.prevTime;
                double result = cpuTime / (double)elapsedTime * 100.0 / (double)processors;
                this.prevTotal = procCpu.getTotal();
                this.prevTime = procCpu.getLastTime();
                return result;
            }
        };
    }

    private static class SigarProcessCpuWrapper
    extends GaugeContextProvider<ProcCpu> {
        private final Sigar sigar = SigarHolder.getSigar();
        private final long pid = this.sigar.getPid();

        private SigarProcessCpuWrapper() {
        }

        @Override
        protected ProcCpu loadValue() {
            try {
                return this.sigar.getProcCpu(this.pid);
            }
            catch (SigarException e) {
                throw new RuntimeException("Failed to get process cpu info from sigar", e);
            }
        }
    }
}

