/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.factories;

import com.gigaspaces.internal.sigar.SigarHolder;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.internal.GaugeContextProvider;
import com.gigaspaces.metrics.internal.InternalGauge;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;

public class SigarSwapMetricFactory {
    private final SigarSwapWrapper context = new SigarSwapWrapper();

    public Gauge<Long> createFreeSwapInBytesGauge() {
        return new InternalGauge<Long>((GaugeContextProvider)this.context){

            @Override
            public Long getValue() throws SigarException {
                return ((Swap)SigarSwapMetricFactory.this.context.get()).getFree();
            }
        };
    }

    public Gauge<Long> createUsedSwapInBytesGauge() {
        return new InternalGauge<Long>((GaugeContextProvider)this.context){

            @Override
            public Long getValue() throws SigarException {
                return ((Swap)SigarSwapMetricFactory.this.context.get()).getUsed();
            }
        };
    }

    public Gauge<Double> createUsedSwapInPercentGauge() {
        return new InternalGauge<Double>((GaugeContextProvider)this.context){

            @Override
            public Double getValue() throws SigarException {
                Swap swap = (Swap)SigarSwapMetricFactory.this.context.get();
                return this.calculatePercent(swap.getUsed(), swap.getTotal());
            }
        };
    }

    private static class SigarSwapWrapper
    extends GaugeContextProvider<Swap> {
        private final Sigar sigar = SigarHolder.getSigar();

        private SigarSwapWrapper() {
        }

        @Override
        protected Swap loadValue() {
            try {
                return this.sigar.getSwap();
            }
            catch (SigarException e) {
                throw new RuntimeException("Failed to get swap info from sigar", e);
            }
        }
    }
}

