/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.reporters;

import com.gigaspaces.metrics.MetricGroupSnapshot;
import com.gigaspaces.metrics.MetricRegistrySnapshot;
import com.gigaspaces.metrics.MetricReporter;
import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.reporters.ConsoleReporterFactory;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;

public class ConsoleReporter
extends MetricReporter {
    private static final int CONSOLE_WIDTH = 80;
    private static final String NEWLINE = System.getProperty("line.separator");
    private final PrintStream output;
    private final DateFormat dateFormat;
    private final StringBuilder buffer = new StringBuilder();

    public ConsoleReporter(ConsoleReporterFactory factory) {
        super(factory);
        this.output = factory.getOutput();
        this.dateFormat = DateFormat.getDateTimeInstance(3, 2, factory.getLocale());
        this.dateFormat.setTimeZone(factory.getTimeZone());
    }

    @Override
    public void report(List<MetricRegistrySnapshot> snapshots) {
        super.report(snapshots);
        this.output.print(this.buffer.toString());
        this.output.flush();
        this.buffer.setLength(0);
    }

    @Override
    protected void report(MetricRegistrySnapshot snapshot) {
        this.printWithBanner(this.dateFormat.format(new Date(snapshot.getTimestamp())), '=');
        super.report(snapshot);
        this.buffer.append(NEWLINE);
    }

    @Override
    protected void report(MetricRegistrySnapshot snapshot, MetricTagsSnapshot tags, MetricGroupSnapshot group) {
        this.buffer.append("\tTags: ").append(tags).append(NEWLINE);
        super.report(snapshot, tags, group);
    }

    @Override
    protected void report(MetricRegistrySnapshot snapshot, MetricTagsSnapshot tags, String key, Object value) {
        this.buffer.append("\t\t").append(key).append(" => ").append(value).append(NEWLINE);
    }

    private void printWithBanner(String s, char c) {
        this.buffer.append(s);
        this.buffer.append(' ');
        for (int i = 0; i < 80 - s.length() - 1; ++i) {
            this.buffer.append(c);
        }
        this.buffer.append(NEWLINE);
    }
}

