/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.reporters;

import com.gigaspaces.metrics.MetricReporterFactory;
import com.gigaspaces.metrics.reporters.ConsoleReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleReporterFactory
extends MetricReporterFactory<ConsoleReporter> {
    private PrintStream output;
    private Locale locale;
    private TimeZone timeZone;

    public ConsoleReporterFactory() {
        this.setOutput(System.out);
        this.setLocale(Locale.getDefault());
        this.setTimeZone(TimeZone.getDefault());
    }

    @Override
    public ConsoleReporter create() {
        Logger logger = Logger.getLogger(ConsoleReporterFactory.class.getName());
        if (logger.isLoggable(Level.FINE)) {
            this.setLoggerAsOutputStream(logger);
        }
        return new ConsoleReporter(this);
    }

    private void setLoggerAsOutputStream(final Logger logger) {
        this.setOutput(new PrintStream(new OutputStream(){
            StringBuilder s = new StringBuilder();

            @Override
            public void write(int b) throws IOException {
                this.s.append((char)b);
            }

            @Override
            public void flush() throws IOException {
                logger.fine(this.s.toString());
                this.s.setLength(0);
            }
        }));
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setOutput(PrintStream output) {
        this.output = output;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }
}

