/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.reporters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metrics.MetricGroupSnapshot;
import com.gigaspaces.metrics.MetricRegistrySnapshot;
import com.gigaspaces.metrics.MetricReporter;
import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.reporters.FileReporterFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class FileReporter
extends MetricReporter {
    private static final Logger logger = Logger.getLogger(FileReporter.class.getName());
    private static final String NEWLINE = System.getProperty("line.separator");
    private final Date date = new Date();
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final File file;
    private final StringBuilder buffer;

    protected FileReporter(FileReporterFactory factory) {
        super(factory);
        File file = new File(factory.getPath());
        file.getParentFile().mkdirs();
        this.file = file.getAbsoluteFile();
        this.buffer = new StringBuilder();
    }

    @Override
    public void report(List<MetricRegistrySnapshot> snapshots) {
        this.buffer.append("Reported at ").append(this.formatDateTime(System.currentTimeMillis())).append(NEWLINE);
        super.report(snapshots);
        this.writeToFile(this.buffer.toString());
        this.buffer.setLength(0);
    }

    @Override
    protected void report(MetricRegistrySnapshot snapshot) {
        this.buffer.append("Sample taken at ").append(this.formatDateTime(snapshot.getTimestamp())).append(NEWLINE);
        super.report(snapshot);
    }

    @Override
    protected void report(MetricRegistrySnapshot snapshot, MetricTagsSnapshot tags, MetricGroupSnapshot group) {
        this.buffer.append("\tTags: ").append(tags).append(NEWLINE);
        super.report(snapshot, tags, group);
    }

    @Override
    protected void report(MetricRegistrySnapshot snapshot, MetricTagsSnapshot tags, String key, Object value) {
        this.buffer.append("\t\t").append(key).append(" => ").append(value).append(NEWLINE);
    }

    private String formatDateTime(long timestamp) {
        this.date.setTime(timestamp);
        return this.dateFormatter.format(this.date);
    }

    private void writeToFile(String text) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.file, true);
            fw.write(text);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to write report to file", e);
        }
        if (fw != null) {
            try {
                fw.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to close FileWriter", e);
            }
        }
    }
}

