/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query;

import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Map;

public abstract class CompoundResult
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected Object[] values;
    protected Map<String, Integer> nameIndexMap;
    protected transient int hashCode;

    public CompoundResult() {
    }

    public CompoundResult(Object[] values, Map<String, Integer> nameIndexMap) {
        this.values = values;
        this.nameIndexMap = nameIndexMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompoundResult)) {
            return false;
        }
        CompoundResult other = (CompoundResult)obj;
        return Arrays.equals(this.values, other.values);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.values);
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        this.printValues(sb, "(", ")");
        return sb.toString();
    }

    protected void printValues(StringBuilder sb, String prefix, String suffix) {
        if (prefix != null) {
            sb.append(prefix);
        }
        if (this.nameIndexMap != null) {
            boolean isFirst = true;
            for (Map.Entry<String, Integer> entry : this.nameIndexMap.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                sb.append(entry.getKey()).append('=').append(this.values[entry.getValue()]);
            }
        } else {
            boolean isFirst = true;
            for (Object value : this.values) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                sb.append(value);
            }
        }
        if (suffix != null) {
            sb.append(suffix);
        }
    }

    public CompoundResult clone() {
        try {
            CompoundResult copy = (CompoundResult)super.clone();
            copy.values = Arrays.copyOf(this.values, this.values.length);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed to clone a cloneable object", e);
        }
    }

    protected int indexOf(String name) {
        Integer result = this.nameIndexMap.get(name);
        if (result == null) {
            throw new IllegalArgumentException("No such name - '" + name + "'");
        }
        return result;
    }

    public int size() {
        return this.values.length;
    }

    public Object get(int index) {
        return this.values[index];
    }

    public void set(int index, Object value) {
        this.values[index] = value;
    }

    public Object get(String name) {
        return this.values[this.indexOf(name)];
    }

    public Boolean getBoolean(int index) {
        return (Boolean)this.get(index);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    public Byte getByte(int index) {
        return (Byte)this.get(index);
    }

    public Byte getByte(String name) {
        return (Byte)this.get(name);
    }

    public Short getShort(int index) {
        return (Short)this.get(index);
    }

    public Short getShort(String name) {
        return (Short)this.get(name);
    }

    public Integer getInt(int index) {
        return (Integer)this.get(index);
    }

    public Integer getInt(String name) {
        return (Integer)this.get(name);
    }

    public Long getLong(int index) {
        return (Long)this.get(index);
    }

    public Long getLong(String name) {
        return (Long)this.get(name);
    }

    public Float getFloat(int index) {
        return (Float)this.get(index);
    }

    public Float getFloat(String name) {
        return (Float)this.get(name);
    }

    public Double getDouble(int index) {
        return (Double)this.get(index);
    }

    public Double getDouble(String name) {
        return (Double)this.get(name);
    }

    public String getString(int index) {
        return (String)this.get(index);
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObjectArray(out, this.values);
        IOUtils.writeObject(out, this.nameIndexMap);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.values = IOUtils.readObjectArray(in);
        this.nameIndexMap = (Map)IOUtils.readObject(in);
    }
}

