/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query;

import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.query.QueryResultType;
import java.util.Arrays;

public class IdQuery<T>
implements ISpaceQuery<T> {
    private final String _typeName;
    private final Object _id;
    private final Object _routing;
    private final QueryResultType _queryResultType;
    private final int _version;
    private String[] _projections;

    public IdQuery(Class<T> type, Object id) {
        this(type.getName(), id, null, QueryResultType.DEFAULT, 0);
    }

    public IdQuery(Class<T> type, Object id, Object routing) {
        this(type.getName(), id, routing, QueryResultType.DEFAULT, 0);
    }

    public IdQuery(Class<T> type, Object id, Object routing, int version) {
        this(type.getName(), id, routing, QueryResultType.DEFAULT, version);
    }

    public IdQuery(Class<T> type, Object id, QueryResultType queryResultType) {
        this(type.getName(), id, null, queryResultType, 0);
    }

    public IdQuery(Class<T> type, Object id, Object routing, QueryResultType queryResultType) {
        this(type.getName(), id, routing, queryResultType, 0);
    }

    public IdQuery(Class<T> type, Object id, Object routing, QueryResultType queryResultType, int version) {
        this(type.getName(), id, routing, queryResultType, version);
    }

    public IdQuery(String typeName, Object id) {
        this(typeName, id, null, QueryResultType.DEFAULT, 0);
    }

    public IdQuery(String typeName, Object id, Object routing) {
        this(typeName, id, routing, QueryResultType.DEFAULT, 0);
    }

    public IdQuery(String typeName, Object id, Object routing, int version) {
        this(typeName, id, routing, QueryResultType.DEFAULT, version);
    }

    public IdQuery(String typeName, Object id, QueryResultType queryResultType) {
        this(typeName, id, null, queryResultType, 0);
    }

    public IdQuery(String typeName, Object id, Object routing, QueryResultType queryResultType) {
        this(typeName, id, routing, queryResultType, 0);
    }

    public IdQuery(String typeName, Object id, Object routing, QueryResultType queryResultType, int version) {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("Argument cannot be null or empty - 'typeName'.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'id'.");
        }
        if (queryResultType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'queryResultType'.");
        }
        if (version < 0) {
            throw new IllegalArgumentException("Argument cannot be less than zero - 'version'");
        }
        this._typeName = typeName;
        this._id = id;
        this._routing = routing;
        this._queryResultType = queryResultType;
        this._version = version;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public Object getId() {
        return this._id;
    }

    public Object getRouting() {
        return this._routing;
    }

    public QueryResultType getQueryResultType() {
        return this._queryResultType;
    }

    public int getVersion() {
        return this._version;
    }

    public IdQuery<T> setProjections(String ... properties) {
        this._projections = properties;
        return this;
    }

    public String[] getProjections() {
        return this._projections;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IdQuery)) {
            return false;
        }
        IdQuery other = (IdQuery)obj;
        return IdQuery.equals(this._typeName, other._typeName) && IdQuery.equals(this._id, other._id) && IdQuery.equals(this._routing, other._routing) && IdQuery.equals((Object)this._queryResultType, (Object)other._queryResultType) && this._version == other._version && Arrays.equals(this._projections, other._projections);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }
}

