/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.query.RawEntryConverter;
import com.gigaspaces.query.aggregators.AggregationResult;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.gigaspaces.query.aggregators.AverageAggregator;
import com.gigaspaces.query.aggregators.CountAggregator;
import com.gigaspaces.query.aggregators.GroupByAggregator;
import com.gigaspaces.query.aggregators.MaxEntryAggregator;
import com.gigaspaces.query.aggregators.MaxValueAggregator;
import com.gigaspaces.query.aggregators.MinEntryAggregator;
import com.gigaspaces.query.aggregators.MinValueAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SumAggregator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AggregationInternalUtils {
    private static final Set<Class> _certifiedAggregators = AggregationInternalUtils.initCertifiedAggregators();

    private static Set<Class> initCertifiedAggregators() {
        HashSet<Class> result = new HashSet<Class>();
        result.add(CountAggregator.class);
        result.add(SumAggregator.class);
        result.add(AverageAggregator.class);
        result.add(MaxValueAggregator.class);
        result.add(MaxEntryAggregator.class);
        result.add(MinValueAggregator.class);
        result.add(MinEntryAggregator.class);
        return result;
    }

    public static List<SpaceEntriesAggregator> getAggregators(AggregationSet aggregationSet) {
        return aggregationSet.getAggregators();
    }

    public static Map<String, Integer> index(List<SpaceEntriesAggregator> aggregators) {
        HashMap<String, Integer> nameIndex = new HashMap<String, Integer>();
        for (int i = 0; i < aggregators.size(); ++i) {
            SpaceEntriesAggregator aggregator = aggregators.get(i);
            String alias = aggregator.getAlias();
            if (alias == null) {
                alias = aggregator.getDefaultAlias();
            }
            nameIndex.put(alias, i);
        }
        return nameIndex;
    }

    public static AggregationResult getFinalResult(List<SpaceEntriesAggregator> aggregators, RawEntryConverter rawEntryConverter) {
        Object[] results = new Object[aggregators.size()];
        for (int i = 0; i < results.length; ++i) {
            aggregators.get(i).setRawEntryConverter(rawEntryConverter);
            results[i] = aggregators.get(i).getFinalResult();
        }
        return new AggregationResult(results, AggregationInternalUtils.index(aggregators));
    }

    public static boolean containsCustomAggregators(List<SpaceEntriesAggregator> aggregators) {
        for (SpaceEntriesAggregator aggregator : aggregators) {
            if (!(aggregator instanceof GroupByAggregator ? AggregationInternalUtils.containsCustomAggregators(((GroupByAggregator)aggregator).getSelectAggregators()) : !_certifiedAggregators.contains(aggregator.getClass()))) continue;
            return true;
        }
        return false;
    }

    public static List<SpaceEntriesAggregator> getSelectors(GroupByAggregator aggregator) {
        return aggregator.getSelectAggregators();
    }
}

