/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.query.aggregators.AverageAggregator;
import com.gigaspaces.query.aggregators.CountAggregator;
import com.gigaspaces.query.aggregators.DistinctAggregator;
import com.gigaspaces.query.aggregators.GroupByAggregator;
import com.gigaspaces.query.aggregators.MaxEntryAggregator;
import com.gigaspaces.query.aggregators.MaxValueAggregator;
import com.gigaspaces.query.aggregators.MinEntryAggregator;
import com.gigaspaces.query.aggregators.MinValueAggregator;
import com.gigaspaces.query.aggregators.OrderByAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SumAggregator;
import java.util.ArrayList;
import java.util.List;

public class AggregationSet {
    private final List<SpaceEntriesAggregator> aggregators = new ArrayList<SpaceEntriesAggregator>();

    public AggregationSet add(SpaceEntriesAggregator aggregator) {
        this.aggregators.add(aggregator);
        return this;
    }

    public AggregationSet count() {
        return this.add(new CountAggregator());
    }

    public AggregationSet count(String path) {
        return this.add(new CountAggregator().setPath(path));
    }

    public AggregationSet sum(String path) {
        return this.add(new SumAggregator().setPath(path));
    }

    public AggregationSet average(String path) {
        return this.add(new AverageAggregator().setPath(path));
    }

    public AggregationSet maxValue(String path) {
        return this.add(new MaxValueAggregator().setPath(path));
    }

    public AggregationSet maxEntry(String path) {
        return this.add(new MaxEntryAggregator().setPath(path));
    }

    public AggregationSet minValue(String path) {
        return this.add(new MinValueAggregator().setPath(path));
    }

    public AggregationSet minEntry(String path) {
        return this.add(new MinEntryAggregator().setPath(path));
    }

    public AggregationSet groupBy(GroupByAggregator aggregator) {
        return this.add(aggregator);
    }

    public AggregationSet orderBy(OrderByAggregator aggregator) {
        return this.add(aggregator);
    }

    public AggregationSet distinct(DistinctAggregator aggregator) {
        return this.add(aggregator);
    }

    List<SpaceEntriesAggregator> getAggregators() {
        return this.aggregators;
    }
}

