/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.math.MutableNumber;
import com.gigaspaces.query.aggregators.AbstractPathAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AverageAggregator
extends AbstractPathAggregator<AverageTuple> {
    private static final long serialVersionUID = 1L;
    private transient AverageTuple result;

    @Override
    public String getDefaultAlias() {
        return "avg(" + this.getPath() + ")";
    }

    @Override
    public void aggregate(SpaceEntriesAggregatorContext context) {
        Number value = (Number)this.getPathValue(context);
        if (value != null) {
            this.result = this.result != null ? this.result.add(value, 1L) : new AverageTuple(value);
        }
    }

    @Override
    public void aggregateIntermediateResult(AverageTuple partitionResult) {
        this.result = this.result == null ? partitionResult : this.result.add(partitionResult.sum.toNumber(), partitionResult.count);
    }

    @Override
    public AverageTuple getIntermediateResult() {
        return this.result;
    }

    @Override
    public Object getFinalResult() {
        return this.result == null ? (Number)null : (Number)this.result.getAverage();
    }

    public static class AverageTuple
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private MutableNumber sum;
        private long count;

        public AverageTuple() {
        }

        public AverageTuple(Number sum) {
            this.sum = MutableNumber.fromClass(sum.getClass(), true);
            this.sum.add(sum);
            this.count = 1L;
        }

        public AverageTuple add(Number deltaSum, long deltaCount) {
            this.count += deltaCount;
            this.sum.add(deltaSum);
            return this;
        }

        public Number getAverage() {
            if (this.count == 0L) {
                return null;
            }
            return this.sum.calcDivision(this.count);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.count);
            IOUtils.writeObject(out, this.sum);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.count = in.readLong();
            this.sum = (MutableNumber)IOUtils.readObject(in);
        }
    }
}

