/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.query.aggregators.AbstractPathAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;

public class CountAggregator
extends AbstractPathAggregator<Long> {
    private static final long serialVersionUID = 1L;
    private transient long result;

    @Override
    public String getDefaultAlias() {
        String path = this.getPath();
        return path == null ? "count(*)" : "count(" + path + ")";
    }

    @Override
    public AbstractPathAggregator setPath(String path) {
        if (path == null || path.length() == 0 || path.equals("*")) {
            path = null;
        }
        return super.setPath(path);
    }

    @Override
    public void aggregate(SpaceEntriesAggregatorContext context) {
        if (this.getPath() == null || this.getPathValue(context) != null) {
            ++this.result;
        }
    }

    @Override
    public void aggregateIntermediateResult(Long partitionResult) {
        this.result += partitionResult.longValue();
    }

    @Override
    public Long getIntermediateResult() {
        return this.result;
    }
}

