/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.RawEntry;
import com.gigaspaces.query.aggregators.DistinctPropertiesKey;
import com.gigaspaces.query.aggregators.DistinctResult;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DistinctAggregator<T>
extends SpaceEntriesAggregator<DistinctResult>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private transient SpaceEntriesAggregatorContext context;
    private String[] distinctPaths;
    private transient Map<DistinctPropertiesKey, RawEntry> map;
    private transient DistinctPropertiesKey key;
    private int limit = Integer.MAX_VALUE;

    public DistinctAggregator distinct(String ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException("No paths were set");
        }
        this.distinctPaths = paths;
        return this;
    }

    public DistinctAggregator distinct(Integer limit, String ... paths) {
        this.limit = limit;
        return this.distinct(paths);
    }

    @Override
    public String getDefaultAlias() {
        return "distinct (" + Arrays.toString(this.distinctPaths) + ")";
    }

    @Override
    public void aggregate(SpaceEntriesAggregatorContext context) {
        this.context = context;
        if (this.map == null) {
            this.map = new HashMap<DistinctPropertiesKey, RawEntry>();
            this.key = new DistinctPropertiesKey(this.distinctPaths.length);
        }
        if (!this.key.initialize(this.distinctPaths, context)) {
            return;
        }
        if (this.map.get(this.key) == null && this.map.size() < this.limit) {
            this.map.put((DistinctPropertiesKey)this.key.clone(), context.getRawEntry());
        }
    }

    @Override
    public void aggregateIntermediateResult(DistinctResult partitionResult) {
        if (this.map == null) {
            this.map = new HashMap<DistinctPropertiesKey, RawEntry>();
        }
        if (partitionResult.getMap() == null) {
            return;
        }
        for (Map.Entry<DistinctPropertiesKey, RawEntry> entry : partitionResult.getMap().entrySet()) {
            if (this.map.get(entry.getKey()) != null || this.map.size() >= this.limit) continue;
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public DistinctResult getIntermediateResult() {
        if (this.map == null) {
            return null;
        }
        for (RawEntry entry : this.map.values()) {
            this.context.applyProjectionTemplate(entry);
        }
        return new DistinctResult(this.map);
    }

    @Override
    public Collection<T> getFinalResult() {
        if (this.map == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (RawEntry entry : this.map.values()) {
            list.add(this.toObject(entry));
        }
        return list;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this.distinctPaths);
        out.writeInt(this.limit);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.distinctPaths = (String[])IOUtils.readObject(in);
        this.limit = in.readInt();
    }
}

