/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.RawEntryConverter;
import com.gigaspaces.query.aggregators.AggregationInternalUtils;
import com.gigaspaces.query.aggregators.AverageAggregator;
import com.gigaspaces.query.aggregators.CountAggregator;
import com.gigaspaces.query.aggregators.GroupByFilter;
import com.gigaspaces.query.aggregators.GroupByKey;
import com.gigaspaces.query.aggregators.GroupByResult;
import com.gigaspaces.query.aggregators.GroupByValue;
import com.gigaspaces.query.aggregators.MaxEntryAggregator;
import com.gigaspaces.query.aggregators.MaxValueAggregator;
import com.gigaspaces.query.aggregators.MinEntryAggregator;
import com.gigaspaces.query.aggregators.MinValueAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import com.gigaspaces.query.aggregators.SumAggregator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupByAggregator
extends SpaceEntriesAggregator<GroupByResult>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String[] groupByPaths;
    private List<SpaceEntriesAggregator> aggregators;
    private transient Map<GroupByKey, SpaceEntriesAggregator[]> map;
    private transient GroupByKey key;
    private transient GroupByFilter filter;

    @Override
    public String getDefaultAlias() {
        return "groupBy" + Arrays.toString(this.groupByPaths);
    }

    public GroupByAggregator groupBy(String ... paths) {
        this.groupByPaths = paths;
        return this;
    }

    public GroupByAggregator having(GroupByFilter filter) {
        this.filter = filter;
        return this;
    }

    private GroupByAggregator addSelector(SpaceEntriesAggregator aggregator) {
        if (this.aggregators == null) {
            this.aggregators = new ArrayList<SpaceEntriesAggregator>();
        }
        this.aggregators.add(aggregator);
        return this;
    }

    protected List<SpaceEntriesAggregator> getSelectAggregators() {
        return this.aggregators;
    }

    public GroupByAggregator select(SpaceEntriesAggregator ... aggregators) {
        for (SpaceEntriesAggregator aggregator : aggregators) {
            this.addSelector(aggregator);
        }
        return this;
    }

    public GroupByAggregator selectCount() {
        return this.addSelector(new CountAggregator());
    }

    public GroupByAggregator selectCount(String path) {
        return this.addSelector(new CountAggregator().setPath(path));
    }

    public GroupByAggregator selectSum(String path) {
        return this.addSelector(new SumAggregator().setPath(path));
    }

    public GroupByAggregator selectAverage(String path) {
        return this.addSelector(new AverageAggregator().setPath(path));
    }

    public GroupByAggregator selectMaxValue(String path) {
        return this.addSelector(new MaxValueAggregator().setPath(path));
    }

    public GroupByAggregator selectMaxEntry(String path) {
        return this.addSelector(new MaxEntryAggregator().setPath(path));
    }

    public GroupByAggregator selectMinValue(String path) {
        return this.addSelector(new MinValueAggregator().setPath(path));
    }

    public GroupByAggregator selectMinEntry(String path) {
        return this.addSelector(new MinEntryAggregator().setPath(path));
    }

    @Override
    public void aggregate(SpaceEntriesAggregatorContext context) {
        SpaceEntriesAggregator[] group;
        if (this.map == null) {
            this.map = new HashMap<GroupByKey, SpaceEntriesAggregator[]>();
            this.key = new GroupByKey(this.groupByPaths.length);
        }
        if (!this.key.initialize(this.groupByPaths, context)) {
            return;
        }
        for (SpaceEntriesAggregator aggregator : group = this.getOrCreate(this.key)) {
            aggregator.aggregate(context);
        }
    }

    private SpaceEntriesAggregator[] getOrCreate(GroupByKey key) {
        SpaceEntriesAggregator[] group = this.map.get(key);
        if (group == null) {
            group = new SpaceEntriesAggregator[this.aggregators.size()];
            for (int i = 0; i < group.length; ++i) {
                group[i] = this.aggregators.get(i).clone();
            }
            this.map.put((GroupByKey)key.clone(), group);
        }
        return group;
    }

    @Override
    public void aggregateIntermediateResult(GroupByResult partitionResult) {
        if (this.map == null) {
            this.map = new HashMap<GroupByKey, SpaceEntriesAggregator[]>();
        }
        for (Map.Entry<GroupByKey, GroupByValue> entry : partitionResult.getMap().entrySet()) {
            SpaceEntriesAggregator[] currValue = this.getOrCreate(entry.getKey());
            for (int i = 0; i < currValue.length; ++i) {
                Serializable currPartitionResult = (Serializable)entry.getValue().get(i);
                if (currPartitionResult == null) continue;
                currValue[i].aggregateIntermediateResult(currPartitionResult);
            }
        }
    }

    @Override
    public GroupByResult getIntermediateResult() {
        if (this.map == null) {
            return null;
        }
        HashMap<GroupByKey, GroupByValue> resultMap = new HashMap<GroupByKey, GroupByValue>();
        for (Map.Entry<GroupByKey, SpaceEntriesAggregator[]> entry : this.map.entrySet()) {
            Object[] values = new Object[this.aggregators.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = entry.getValue()[i].getIntermediateResult();
            }
            resultMap.put(entry.getKey(), new GroupByValue(values));
        }
        return new GroupByResult(resultMap);
    }

    @Override
    public Object getFinalResult() {
        if (this.map == null) {
            return new GroupByResult(new HashMap<GroupByKey, GroupByValue>());
        }
        HashMap<String, Integer> keyNameIndex = new HashMap<String, Integer>();
        for (int i = 0; i < this.groupByPaths.length; ++i) {
            keyNameIndex.put(this.groupByPaths[i], i);
        }
        Map<String, Integer> valueNameIndex = AggregationInternalUtils.index(this.aggregators);
        HashMap<GroupByKey, GroupByValue> resultMap = new HashMap<GroupByKey, GroupByValue>();
        for (Map.Entry<GroupByKey, SpaceEntriesAggregator[]> entry : this.map.entrySet()) {
            GroupByKey key = entry.getKey();
            key.setNameIndex(keyNameIndex);
            Object[] values = new Object[this.aggregators.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = entry.getValue()[i].getFinalResult();
            }
            resultMap.put(key, new GroupByValue(values, valueNameIndex, key));
        }
        GroupByResult result = new GroupByResult(resultMap);
        if (this.filter != null) {
            result.filter(this.filter);
        }
        return result;
    }

    @Override
    protected void setRawEntryConverter(RawEntryConverter rawEntryConverter) {
        super.setRawEntryConverter(rawEntryConverter);
        if (this.map != null) {
            for (SpaceEntriesAggregator[] aggregators : this.map.values()) {
                for (SpaceEntriesAggregator aggregator : aggregators) {
                    aggregator.setRawEntryConverter(rawEntryConverter);
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeStringArray(out, this.groupByPaths);
        IOUtils.writeObject(out, this.aggregators);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.groupByPaths = IOUtils.readStringArray(in);
        this.aggregators = (List)IOUtils.readObject(in);
    }
}

