/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.query.aggregators.GroupByFilter;
import com.gigaspaces.query.aggregators.GroupByKey;
import com.gigaspaces.query.aggregators.GroupByValue;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Map;

public class GroupByResult
implements Externalizable,
Iterable<GroupByValue> {
    private static final long serialVersionUID = 1L;
    private Map<GroupByKey, GroupByValue> map;

    public GroupByResult() {
    }

    public GroupByResult(Map<GroupByKey, GroupByValue> map) {
        this.map = map;
    }

    protected Map<GroupByKey, GroupByValue> getMap() {
        return this.map;
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public Iterator<GroupByValue> iterator() {
        return this.map.values().iterator();
    }

    public GroupByValue get(Object ... keys) {
        return this.map.get(new GroupByKey(keys));
    }

    public GroupByValue get(GroupByKey key) {
        return this.map.get(key);
    }

    public void filter(GroupByFilter filter) {
        Iterator<Map.Entry<GroupByKey, GroupByValue>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<GroupByKey, GroupByValue> entry = iterator.next();
            if (filter.process(entry.getValue())) continue;
            iterator.remove();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this.map);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.map = (Map)IOUtils.readObject(in);
    }
}

