/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.query.RawEntry;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.util.ArrayList;

public class ListEntriesAggregator
extends SpaceEntriesAggregator<ArrayList<RawEntry>> {
    private static final long serialVersionUID = 1L;
    private transient ArrayList<RawEntry> result;

    @Override
    public String getDefaultAlias() {
        return "ListEntries";
    }

    @Override
    public void aggregate(SpaceEntriesAggregatorContext context) {
        if (this.result == null) {
            this.result = new ArrayList();
        }
        this.result.add(context.getRawEntry());
    }

    @Override
    public ArrayList<RawEntry> getIntermediateResult() {
        return this.result;
    }

    @Override
    public void aggregateIntermediateResult(ArrayList<RawEntry> partitionResult) {
        if (partitionResult != null) {
            if (this.result == null) {
                this.result = partitionResult;
            } else {
                this.result.addAll(partitionResult);
            }
        }
    }

    @Override
    public Object getFinalResult() {
        ArrayList<RawEntry> list = this.result;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (RawEntry)this.toObject(this.result.get(i)));
            }
        }
        return this.result;
    }
}

