/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.query.aggregators;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.RawEntry;
import com.gigaspaces.query.aggregators.AbstractPathAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MinEntryAggregator
extends AbstractPathAggregator<MinEntryScannerResult> {
    private static final long serialVersionUID = 1L;
    private transient MinEntryScannerResult result;

    @Override
    public String getDefaultAlias() {
        return "minEntry(" + this.getPath() + ")";
    }

    @Override
    public void aggregate(SpaceEntriesAggregatorContext context) {
        Comparable value = (Comparable)this.getPathValue(context);
        if (this.result == null) {
            this.result = new MinEntryScannerResult(context.getRawEntry(), value);
        } else if (this.result.value.compareTo(value) > 0) {
            this.result.entry = context.getRawEntry();
            this.result.value = value;
        }
    }

    @Override
    public void aggregateIntermediateResult(MinEntryScannerResult partitionResult) {
        this.result = this.result == null || this.result.value.compareTo(partitionResult.value) > 0 ? partitionResult : this.result;
    }

    @Override
    public MinEntryScannerResult getIntermediateResult() {
        return this.result;
    }

    @Override
    public Object getFinalResult() {
        return this.result == null ? null : this.toObject(this.result.getRawEntry());
    }

    public static class MinEntryScannerResult
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private RawEntry entry;
        private Comparable value;

        public MinEntryScannerResult() {
        }

        private MinEntryScannerResult(RawEntry entry, Comparable value) {
            this.entry = entry;
            this.value = value;
        }

        public RawEntry getRawEntry() {
            return this.entry;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            IOUtils.writeObject(out, this.entry);
            IOUtils.writeObject(out, this.value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.entry = (RawEntry)IOUtils.readObject(in);
            this.value = (Comparable)IOUtils.readObject(in);
        }
    }
}

